//    

/*++
makeEntry -- create an entry for a domain

makeEntry(Dom, e)

Dom - domain
e   - entry name (string)

makeEntry searches for a definition of a domain entry and creates
the entry if its definition is found.

makeEntry returns a list with 2 entries:
1- the entry found or toBeDefined or FAIL
2- the domain or category which defined the entry or FAIL
++*/

DomainConstructor::makeEntry:= proc(DOM: DOM_DOMAIN, e: DOM_STRING)
    option noDebug;
    local r;
begin
    // search for entry in constructor 
    r:= extop(DOM::constructor,4);
    if contains(r, e) then
	// evaluate entry in closure of domain 
	r:= _eval_entry(indexval(r, e), DOM, DOM::closure);
        if r <> NIL and r <> null() then
            return([r, DOM])
        end_if;
    end_if;

    // search for entry in super-domains 
    r:= DomainConstructor::getSuperDomainEntry(DOM, e);
    if r[1] <> FAIL then return(r) end_if;

    // search for entry in categories 
    r:= CategoryConstructor::getEntry(DOM, e);
    if r[1] <> FAIL then return(r) end_if;

    // finally, try to find a "default_slot"" entry
    // the entry "default_slot" itself cannot be created in this way
    if e <> "default_slot" then
      r:= DOM::default_slot(DOM, e);
      if r<>FAIL then return([r, DOM]) end_if;
    end_if;
                                 
    // none of the above methods worked                              
    [FAIL, FAIL]                             
end_proc:

// end of file 
