//    

/*++
TeX -- returns string with domain constructor in (La)TeX format

TeX(D)

D - domain or domain constructor
++*/

DomainConstructor::TeX:= proc(DC): DOM_STRING
    option noDebug;
    local init, str, e, l, texstr;
begin
    if args(0) <> 1 then error("wrong no of args") end_if;
    if domtype(DC) <> DomainConstructor then
        DC:= DC::constructor;
        if DC = FAIL then error("no constructor") end_if
    end_if;

    texstr:= proc(x) begin
        if x = "" then "" else
            _concat(op(subs(text2list(x,["_"]), "_"="\\_")))
        end_if
    end_proc;

    // header 
    init:= extop(DC,1);
    str:= "\n\\begin{muDomain}{".expr2text(op(init,6)).
          "}{% short description\n}\n\n";

    // syntax 
    if op(init,1) = NIL then
        str:= str."\\muConstSyntax{}\n\n";
    else
        str:= str."\\muSyntax{".texstr(expr2text(op(init,1)))."}\n\n";
    end_if;

    // super-domain 
    str:= str."\\muSuperDomain{".texstr(expr2text(
	    if extop(DC,5) = NIL then "" else extop(DC,5)[1] end
	    ))."}\n\n";

    // categories 
    str:= str."\\muCategories{".texstr(expr2text(op(extop(DC,2))))."}\n\n";

    // axioms 
    str:= str."\\muAxioms{".texstr(expr2text(op(extop(DC,3)))).
                "}\n\n% domain description\n\n";

    // entries 
    l:= sort(map([ op(extop(DC,4)) ], op, 1));
    if nops(l) > 0 then
        str:= str."\\begin{muMethods}\n\n";
        for e in l do
            str:= str."\\muMethod{".texstr(e).
                    "}{% arguments\n}{% method description\n}\n";
        end_for;
        str:= str."\n\\end{muMethods}\n\n";
    end_if;

    str."\\end{muDomain}\n\n";
end_proc:

// end of file 
