//    
/*++
DomainConstructor -- the domain of domain constructors

A domain constructors is used to create domains depending upon
parameters.

Normally no method of the domain 'DomainConstructor' is
called by the domain constructor implementor. All methods are
called implicitly.

A domain constructor is an element of DomainConstructor with the
following operands:

0 - the domain DomainConstructor
1 - the init-procedure of the constructor (a procedure)
2 - a list of expressions which must evaluate to categories
3 - a list of expressions which must evaluate to axioms
4 - a domain with the entries for the categories to construct
5 - an expression which must evaluate to a list containing a domain or NIL

Domain instances are created by the method 'func_call'. The initialization
procedure (op 1) is called with the actual parameters and is used
to create a closure for the domain.

Only some basic entries which are needed anyway are created for the domain.
If later on any other entry is needed it's created on the fly by the method
'getEntry'.

The entries created with 'func_call' are: 'key', 'slot', 'constructor',
'closure', 'super_domains', 'categories', 'categories_idx' and 'axioms'.
'constructor' ist the domain constructor for the domain. 'closure' is
the closure of the domain used to evaluate its entries. 'slot'
always has the value 'DomainConstructor::getEntry', this entry is used
to create domain entries on the fly. 'super_domains' is a list of all
super-domains, 'categories' a list of all direct categories and 'axioms'
a set of all direct axioms of the domain and its direct categories.

The categories of a domain are created on demand by the iterator
'DomainConstructor::getCategory'. As a side-effect the categories
created are inserted into the list 'categories'. (The entry
'categories_idx' is the index of the next category for which to create
the direct super-categories.) As a second side-effect the direct axioms
of a new categories created are inserted into the entry 'axioms'. This
mechanism makes the creation of new domains a lot faster, but is quite
obscure due to the side-effects.

If a domain entry is evaluated (via 'slot' or '::') and not already
created by the constructor, the entry is looked up by 'getEntry' in the
entry table (op 4 of the constructor). If there is an entry defined in the
constructor, this will be used to create the entry of the domain. If there
is no entry in the domain constructor the super-domains of the domain and
then, if the super-domains can't define the entry, the categories of the
domain will be asked to create the entry.

If an entry is found, it is evaluated in the closure of the domain,
the result is inserted into the domain.

The super-domains of a domain are created by the method 'func_call' when the
domain is created. The 5th op of the constructor contains an expression
which is evaluated in the closure of the domain. The result must be a 
list containing the super-domain or NIL.

If a super-domain exists that domain is queried for the entry by the method
'DomainConstructor::getSuperDomainEntry'. This methods searches in the
super-domain and - if necessary - the super-domains of the super-domain for
the entry. If the entry is found it is changed into an entry for the actual
domain by evaluating it in the closure of the super-domain.

Note that the super-domains don't query their categories to create the
entry! If the actual domain at hand is in a sub-category of the categories
of the super-domain such an category entry would overwrite an entry
definition in the sub-category, causing a loss of information. (The more
specific entry in the sub-category would be hidden by the entry in the
super-category.)

If the super-domains do not define the entry the categories of the domain
are asked to create the entry. The categories are created on demand and
stored in the entry 'categories'. The 2nd op of the constructor contains
a list of expressions which is evaluated in the closure of the domain.
The result is suspected to be a list of categories.

A domain may be queried for certain categories or axioms by the method
'hasProp'. The axioms of a domain are created when their category are
created and stored in the entry 'axioms'.
++*/

DomainConstructor:= newDomain("DomainConstructor"):
DomainConstructor::info:=
    "Domain 'DomainConstructor'":
DomainConstructor::interface:= {}:
DomainConstructor::create_dom:= hold(DomainConstructor):
DomainConstructor::subs:= x -> x;

alias(path=pathname("DOMAINS", "CONSTR")):

DomainConstructor::allDomainEntries:= loadproc(DomainConstructor::allDomainEntries, path, "DCDomEnt");
DomainConstructor::getSuperDomainEntry:= loadproc(DomainConstructor::getSuperDomainEntry, path, "DCSDEnt");
DomainConstructor::allEntries:= loadproc(DomainConstructor::allEntries, path, "DCallEnt");
DomainConstructor::allSuperDomainEntries:= loadproc(DomainConstructor::allSuperDomainEntries, path, "DCallSDE");
DomainConstructor::axioms:= loadproc(DomainConstructor::axioms, path, "DCaxioms");
DomainConstructor::categories:= loadproc(DomainConstructor::categories, path, "DCcateg");
DomainConstructor::func_call:= loadproc(DomainConstructor::func_call, path, "DCfcall");
DomainConstructor::getEntry:= loadproc(DomainConstructor::getEntry, path, "DCgetEnt");
DomainConstructor::hasProp:= loadproc(DomainConstructor::hasProp, path, "DChasPro");
DomainConstructor::makeEntry:= loadproc(DomainConstructor::makeEntry, path, "DCmkEnt");
DomainConstructor::print:= loadproc(DomainConstructor::print, path, "DCprint");
DomainConstructor::create_dom_elem:= loadproc(DomainConstructor::create_dom_elem, path, "DCprint");
DomainConstructor::TeX:= loadproc(DomainConstructor::TeX, path, "DCtex");
DomainConstructor::undefinedEntries:= loadproc(DomainConstructor::undefinedEntries, path, "DCundEnt");
DomainConstructor::whichEntry:= loadproc(DomainConstructor::whichEntry, path, "DCwhEnt");
DomainConstructor::testtype:= loadproc(DomainConstructor::testtype, path, "DCttype");
DomainConstructor::_index:= loadproc(DomainConstructor::_index, path, "DCindex");
DomainConstructor::printInfo:= loadproc(DomainConstructor::printInfo, path, "DCprInfo");
DomainConstructor::getCategory:= loadproc(DomainConstructor::getCategory, path, "DCgetCat");

// end of file 
