/*
        Dom::Complex  --  the field of complex numbers

        The domain has category Cat::Field, which is very optimistic 
        (indeed false, because for example bool(1.0 = float(3) / float(3))
        FALSE. The category is assumed only because of pragmatism.
        Note that elements may not have an unique representation, for 
        example bool( 0 = sin(2)^2 + cos(2)^2 - 1 ) returns FALSE.
*/

domain Dom::Complex
  inherits Dom::BaseDomain;
  category Cat::DifferentialRing, Cat::Field;
  axiom Ax::systemRep, 
        Ax::efficientOperation("_divide"), Ax::efficientOperation("_mult"),
        Ax::efficientOperation("_invert");

// ----------------
// --- Methods: ---
// ----------------

characteristic:= 0;

convert:= proc(x)
  local tmp;
begin
  if args(0)<>1 then
    return(FAIL)
  end_if;

  case domtype(x)
    of DOM_INT     do
    of DOM_RAT     do
    of DOM_FLOAT   do
    of DOM_COMPLEX do 
      return( x )
    of DOM_IDENT do
      if contains( Type::ConstantIdents,x ) then
        return( x )
      else
        return( FAIL )
      end_if
    of DOM_EXPR do
      if testtype(x, Type::Arithmetical)
        and (tmp:= indets(x)) = {} or tmp minus Type::ConstantIdents = {}
        then
        return( x )
      end_if
    otherwise
      return( FAIL )
  end_case
end_proc;

convert_to:= proc(z,T)
begin
  if domtype(z) = T then
    return( z )
  elif T::dom <> DOM_DOMAIN then
    T:= T::dom
  end_if;
  
  case T
    of DOM_FLOAT do
    of Dom::Float do
      if iszero(Im(z)) then
        return( float(Re(z)) )
      else
        return(FAIL)
      end_if
    of Dom::Real do
      if iszero(Im(z)) then
        return( Re(z) )
      else
        return(FAIL)
      end_if
    of Dom::Numeric  do
    of dom do
    of Dom::ArithmeticalExpression do
      return( z )
    of Dom::Integer do
      if domtype(z) = DOM_INT then
        return( z )
      else
        return( FAIL )
      end_if
    of Dom::Rational do
      if domtype(z) = DOM_INT or domtype(z) = DOM_RAT then
        return( z )
      else
        return( FAIL )
      end_if
    otherwise
        if T::constructor = Dom::ExpressionField then
            return(T::coerce( z ))
        else
            return( FAIL )
        end_if
  end_case
end_proc;

random:= proc(n)
  option escape;
  local randgen;
begin
  if args(0) = 0 then
    return( random(args())+I*random(args()) )
  else
    randgen:=random(n);
    return( () -> randgen() + I*randgen() )
  end_if
end_proc;

_plus:= _plus;

_mult:=_mult;

_power:=_power;

_invert:= _invert;

_negate:= _negate;

_divide:= _divide;

zero:= 0;

one:= 1;

expr:= expr;

conjugate:= conjugate;

normal:= normal;

iszero:= iszero;

equal:= _equal;

unequal:= _unequal;

_unequal:= _unequal;

norm:= abs;
                    
D:= 0;

diff:= z -> (if args(0) = 1 then z else 0 end_if);

domsolve:= proc(eqs, vars, options)
begin
  options[Domain]:=hold(Expr);
  // convert polys to expressions
  eqs:= misc::maprec(eqs, {DOM_POLY}=expr);
  solve(eqs, vars, options)
end_proc;

TeXrep := x -> "\\mathbb{C}";


// ---------------------------
// --- Body of the domain: ---
// ---------------------------
begin
  if args(0) <> 0 then
    error("no arguments expected")
  end_if
end_domain:

