/*   
*/
/*++
Dom::Expression -- the domain of expressions

The domain of expressions formed by basic domains like DOM_INT or
DOM_EXPR built up by the internal operators.

Dom::Expressions are not represented explicitly but rather as elements
basic domain elements built into the MuPAD kernel.

Methods:-
convert(e)      - convert the expression e into an Dom::Expression, ie. e itself
convert_to(e,D) - convert Dom::Expression e into element of domain D
expr(e)         - convert Dom::Expression e into an expression, ie. into e itself
testtype(e,D)   - test if e is an Dom::Expression
equal(x,y)	- tests if two Dom::Expressions are equal
TeX(x)		- returns TeX(x) (with the library function TeX)
subs(x,...)	- is equal to the kernel function subs
subsex(x,...)	- is equal to the kernel function subsex
random()	- returns a random rational expression
float(e)	- return the floating-point evaluation of e
++*/

domain Dom::Expression

inherits Dom::BaseDomain;

category Cat::BaseCategory;

axiom Ax::systemRep, Ax::efficientOperation("_divide"),
      Ax::efficientOperation("_mult"), Ax::efficientOperation("_invert");

    convert:= expr;

    convert_to:= proc(x,T) begin
	if T = dom then x else FAIL end_if
    end_proc;

    expr:= id;

    testtype:= proc(x /*,T*/) begin
        // there are no elements x of 'dom', so T must be 'dom' 
	if dom::convert(x) = FAIL then FAIL else TRUE end_if
    end_proc;

    equal:= bool @ _equal;

    TeX:= generate::TeX;

    subs:= subs;

    subsex:= subsex;
    
    randomIdent:= genident("R");

    random:= proc() local r; begin
        r:= polylib::randpoly([dom::randomIdent], hold(Expr));
        if iszero(r) then 0
        else expr(polylib::randpoly([dom::randomIdent], hold(Expr))) / expr(r)
        end_if
    end_proc;

    float:= float;

end_domain:

