//    
/*++
Dom::Float -- the domain of floating point numbers

A floating point number is represented by an expression of type DOM_FLOAT.

This domain has category Cat::Field, which is very optimistic. Of course the
implementation is not a field because for example
bool(1.0 = float(3) / float(3))
returns FALSE. Only because of pragmatism floats are assumed do be a field.

Methods:-
_less(x,y)    - returns TRUE iff x < y (in boolean contex only)
_leequal(x,y) - returns TRUE iff x <= y (in boolean contex only)
convert(x)    - returns the value of x converted to Dom::Float
testtype(x,T) - returns TRUE if x is of a floating point type, otherwise 
	       	FAIL
++*/

domain Dom::Float
    // no locals 
    inherits Dom::Numerical;
    category Cat::Field, Cat::DifferentialRing, Cat::OrderedSet;
    axiom Ax::canonicalRep, Ax::systemRep, Ax::canonicalOrder,
          Ax::efficientOperation("_divide"), Ax::efficientOperation("_mult"),
          Ax::efficientOperation("_invert");

    zero := 0.0;

    one:= 1.0;

    testtype := proc(e,T)
    begin
      if T = dom and contains({DOM_INT,DOM_RAT,DOM_FLOAT}, domtype(e)) then 
        TRUE 
      else 
        FAIL 
      end_if
    end_proc;

    convert := proc(x)
        local e;
    begin
        e:= float(x);
        if domtype(e) = DOM_FLOAT then return(e) else return(FAIL) end
    end_proc;

    convert_to :=  proc(x,T) 
    begin
        if not contains({DOM_INT,DOM_RAT,DOM_FLOAT}, domtype(x)) then 
            return(FAIL)
        else
            case T
            of Dom::Float do
            of DOM_FLOAT do 
                return(float(x))
            of Dom::Numerical do 
                return(x)
            otherwise 
                return(FAIL)
            end_case
         end_if
    end_proc;
    
    min := min;

    max := max;
    
    random := () -> tan(float(PI) * (random()/(10.0^12) - 0.5));

    pivotSize := x -> 1/abs(x);
end_domain:

