// 
/*++
Dom::FloatIV -- the domain of floating-point intervals

A floating point interval is represented as an element of type DOM_INTERVAL.

This domain has category Cat::Field, which is simply nonsense
mathematically, but allows to use this domain in a lot of situations
where the algorithms as implemented demand a field technically, while
in reality they do work over intervals, too.

++*/

domain Dom::FloatIV
   inherits Dom::Numerical;
   category Cat::Field, Cat::DifferentialRing;
   axiom Ax::canonicalRep,
         Ax::efficientOperation("_plus"), Ax::efficientOperation("_mult"),
         Ax::efficientOperation("_invert"), Ax::efficientOperation("_divide");

   zero := hull(0);

   one := hull(1);

   testtype := proc(e,T)
   begin
     if T in {dom, DOM_INTERVAL} 
        and // contains({DOM_INT,DOM_RAT,DOM_FLOAT,DOM_INTERVAL}, domtype(e)) 
            domtype(e) = DOM_INTERVAL
     then TRUE
     elif T in {dom, DOM_INTERVAL} and e = {}
     then TRUE
     else FAIL
     end_if
   end_proc;

   convert := interval;

   convert_to := proc(x, T)
   begin
        FAIL
   end_proc;

   random := () -> hull(frandom(),frandom());

   // Various methods passed through from DOM_INTERVAL
   Im        := DOM_INTERVAL::Im;
   Re        := DOM_INTERVAL::Re;
   abs       := DOM_INTERVAL::abs;
   arccos    := DOM_INTERVAL::arccos;
   arccosh   := DOM_INTERVAL::arccosh;
   arccot    := DOM_INTERVAL::arccot;
   arccoth   := DOM_INTERVAL::arccoth;
   arccsc    := DOM_INTERVAL::arccsc;
   arccsch   := DOM_INTERVAL::arccsch;
   arcsec    := DOM_INTERVAL::arcsec;
   arcsech   := DOM_INTERVAL::arcsech;
   arcsin    := DOM_INTERVAL::arcsin;
   arcsinh   := DOM_INTERVAL::arcsinh;
   arctan    := DOM_INTERVAL::arctan;
   arctanh   := DOM_INTERVAL::arctanh;
   arg       := DOM_INTERVAL::arg;
   beta      := DOM_INTERVAL::beta;
   ceil      := DOM_INTERVAL::ceil;
   center    := DOM_INTERVAL::center;
   cos       := DOM_INTERVAL::cos;
   cosh      := DOM_INTERVAL::cosh;
   cot       := DOM_INTERVAL::cot;
   coth      := DOM_INTERVAL::coth;
   csc       := DOM_INTERVAL::csc;
   dirac     := DOM_INTERVAL::dirac;
   exp       := DOM_INTERVAL::exp;
   floor     := DOM_INTERVAL::floor;
   gamma     := DOM_INTERVAL::gamma;
   ln        := DOM_INTERVAL::ln;
   mag       := DOM_INTERVAL::mag;
   mig       := DOM_INTERVAL::mig;
   round     := DOM_INTERVAL::round;
   sec       := DOM_INTERVAL::sec;
   sign      := DOM_INTERVAL::sign;
   sin       := DOM_INTERVAL::sin;
   sinh      := DOM_INTERVAL::sinh;
   sqrt      := DOM_INTERVAL::sqrt;
   tan       := DOM_INTERVAL::tan;
   tanh      := DOM_INTERVAL::tanh;
   trunc     := DOM_INTERVAL::trunc;
   width     := DOM_INTERVAL::width;

end_domain:
