//   


/* domain of multisets (sets with repetitions).

  Available methods: contains, convert, expr, has, intersect, nops, op, print, union

  Example:

>> m:=Dom::Multiset(a,a,b): n:=Dom::Multiset(a,c,c):
>> m,n;

                    {[a, 2], [b, 1]}, {[a, 1], [c, 2]}

>> m union n;

                         {[b, 1], [a, 3], [c, 2]}

>> m intersect n;

                                 {[a, 1]}
*/

domain Dom::Multiset
  local normalize;
  inherits Dom::BaseDomain;
  category Cat::Set;

    /* entries */

      
    contains:= x -> contains(map({extop(x)},op,1),args(2));

    sort:= x -> sort(expr(x),args(2..args(0)));
    
    simpexIn:=
    proc(a, x)
    begin
      simplify::simplifyCondition(a in map({extop(x)},op,1))
    end_proc;

    // multiplicity(S,x) - returns the multiplicity of x in S
    
    multiplicity:=
    proc(S:dom, x)
    begin
      select([extop(S)], u->u[1]=x);
      // gives a list [[x, n1], [x,n2], .., [x, nk]]
      // where k=1 unless S has not been normalized

      // extract the sec. operands (giving [n1, ...,nk]) and add them
      _plus(op(map(%, _index, 2)))
    end_proc;
      

    subs:=
    proc(S)
      local otherargs;
    begin
      otherargs:=args(2..args(0));
      new(dom, op(map([extop(S)], u-> [subs(u[1], otherargs), u[2]])));
      normalize(%)
    end_proc;
        

    new:=
    proc()
      local x,s,i,j,n;
    begin
      if args(0)=0 then
        // empty set
        return({})
      end_if;
      x:=sort([args()], sysorder); n:=nops(x); s:=null();
      i:=1;
      while i<=n do
        for j from i+1 to n do
          if x[i]<>x[j] then
            break
          end_if
        end_for;
        s:=s,[x[i],j-i];
        i:=j
      end_while;
      new(dom,op({s}))
    end_proc;


    // new2: create a domain element from a sequence of pairs
    // [object, multiplicity], taking care to produce an empty *set*
    // if there are no args
    new2:=
    proc()
    begin
      if args(0) = 0 then
        {}
      else
        new(dom, args())
      end_if
    end_proc;
    

    convert:=
    proc(x)
    begin
      if args(0)<>1 then
        error("Wrong number of arguments")
      end_if;
      case type(x)
        of dom do
          return(x)
        of DOM_SET do
          if nops(x)=0 then
            return(x)
          else
            x:= sort([op(x)], sysorder);
            return(new(dom, op(map(x, DOM_LIST, 1))))
          end_if
        of DOM_LIST do
          if nops(x)=0 then
            return({})
          else
            // check
            if map({op(x)}, type)<>{DOM_LIST} or
              map({op(x)}, nops) <>{2} or
              not testtype(map(x, op, 2), Type::ListOf(Type::PosInt)) then
              return(FAIL)
            else
              return(normalize(new(dom, op(x))))
            end_if
          end_if
      end_case;
      FAIL
    end_proc;
    
    convert_to:=
    proc(x:dom, T)
    begin
      case T
        of dom do
          return(x)
        of DOM_SET do
          // forget about all multiplicities
          return(map({extop(x)}, op, 1))
        of DOM_LIST do
          return([extop(x)])
        of "_exprseq" do
        of DOM_EXPR do
          // return a sequence s such that dom::new(s)=x
          return(map(extop(x), l -> _seqgen(op(l,1), op(l,2))))
      end_case;
      FAIL
    end_proc;


    evaluate:= S -> dom::map(S, eval);
    
    expand:= x -> op(map([extop(x)],x->(op(x,1)$op(x,2))));

    has:= x -> has(map([extop(x)], op, 1) ,args(2));


    bin_intersect:=
    proc(S:dom, T:dom)
      local set,d;
    begin
      d:=dom;
      // iterate over the smaller set
      set:= if extnops(S)<= extnops(T) then
              dom::convert_to(S, DOM_SET)
            else
              dom::convert_to(T, DOM_SET)
            end_if;

      map(set, proc(x)
               begin
                 min(d::multiplicity(S,x), d::multiplicity(T,x));
                 if %>0 then
                   [x,%]
                 else
                   null()
                 end_if
               end_proc
          );
      dom::new2(op(%))
    end_proc;

    inhomog_intersect:=
    table(
          DOM_SET=
          proc(x,y:DOM_SET)
          begin
            map({extop(x)}, _index, 1) intersect y
          end_proc
          );



    // nops: number of elements, counted *without* multiplicity

    nops:= extnops;


    // card: number of elements, counted *with* multiplicity
    card:=
    proc(x: dom): DOM_INT
    begin
      _plus(op(map([extop(x)], _index, 2)))
    end_proc;
    
           

    _index:= extop;

    expr:= x -> if extnops(x)=0 then {} else {extop(x)} end_if;


    homog_union:=
    proc()
      local i:DOM_INT;
    begin
      extop(args(i)) $i=1..args(0);
      normalize(new(dom, %))
    end_proc;
      
    inhomog_union:=
    table(
          DOM_SET=
          proc(x,y:DOM_SET)
          begin
            if y={} then
              x
            else  
              x union Dom::Multiset(op(y))
            end_if
          end_proc
          );
    

    
    // nested union - union of a multiset consisting of
    // sets and multisets
    
    nestedUnion:=
    proc(S)
    begin
      case type(S)
        of dom do
          _union(expand(S)); break
        of DOM_SET do
          _union(op(S)); break
        of piecewise do
          map(S, dom::nestedUnion); break
        otherwise
          error("Unknown type ".expr2text(type(S))." of argument")
      end_case
    end_proc;

    normal:= x -> dom::map(x, normal);
    
    select:=
    proc(x, f)
      local otherargs;
    begin
      if args(0)<2 then
        error("Wrong number of arguments")
      end_if;
      otherargs:=args(3..args(0));
      select([extop(x)], u -> f(u[1], otherargs));
      if %=[] then
        {}
      else  
        new(dom, op(select([extop(x)], u -> f(u[1], otherargs))))
      end_if
    end_proc;

    split:=
    proc(x, f)
      local
        otherargs,
        i: DOM_INT;
    begin
      if args(0)<2 then
        error("Wrong number of arguments")
      end_if;
      otherargs:=args(3..args(0));
      split([extop(x)], u -> f(u[1], otherargs));
      [dom::new2(op(op(%,i))) $i=1..3]
    end_proc;

    
    // the method map maps f on the elements of the multiset 
    map:=
    proc(x,f) 
      local otherargs;
    begin
      if nops(x)= 0 then
        return(x)
      end_if;
      if args(0)>=3 then
        otherargs:=args(3..args(0));
        normalize(new(dom,
                      op(map([extop(x)],
                          y -> [f(y[1], otherargs), y[2] ] ) ) ))
      else
        normalize(new(dom,
                      op(map([extop(x)],
                          y -> [f(y[1]), y[2] ] ) ) ))
      end_if
    end_proc;

    bin_minus:=
    proc(s: dom, t:dom)
      local d;
      
    begin
      d:=dom;
      dom::new2(op(map([extop(s)],
                      proc(l)
                        name diminishMultiplicity;
                        // for each entry l=[x,n] of s
                        // if x has multiplicity k in t,
                        // then x must have multiplicity n-k in the result
                        // but its multiplicity must not become negative 
                      begin
                        l[2]-d::multiplicity(t, l[1]);
                        if %<=0 then
                          null()
                        else
                          [l[1], %]
                        end_if
                      end_proc))
          )
    end_proc;

    inhomogleft_minus:=
    table(
          DOM_SET =
          proc(s, S:DOM_SET)
          begin
            if S={} then
              s
            else  
              s minus Dom::Multiset::convert(S)
            end_if;
          end_proc
          );

    inhomogright_minus:=
    table(
          DOM_SET =
          proc(S:DOM_SET, s)
          begin
            select(S, x -> not contains(s, x))
          end_proc
            );
  
    powerset:=
    proc(s: dom)
      local pows;
      
    begin
   
   // pows: given the operands of a multiset  [el, multiplicity], 
   //  returns a list of all sub-multisets 

      pows:=
      proc(el)
        local n;
      begin
        userinfo(20, "pows called with argument ".expr2text(args()));
        if args(0)=0 then
          [[]]
        else
          pows(args(2..args(0)));
          _concat(%, map(%,append, [el[1], n]) $n=1..el[2])
        end_if
      end_proc;

      {op(map(pows(extop(s)), x -> new(type(s), op(x))))};
    end_proc;


    random:=
    proc():dom
      local i, rnd;

    begin
      rnd:=random(20);
      dom(random() $i=1..rnd())
    end_proc;


    // overload solvelib::getElement
    
    getElement:=
    proc(S:dom)
      local n, i;
    begin
      if args(0) = 2 then
        if args(2) <> Random then
          error("Illegal option")
        end_if;
        n:= 1 + (random() mod dom::card(S));
        // return the n-th element
        for i from 1 to nops(S) do
          n:= n - extop(S, i)[2];
          if n <= 0 then
            return(extop(S, i)[1])
          end_if
        end_for;
      else
        extop(S,1)[1]
      end_if
    end_proc;

    isFinite:= TRUE;
    
    equal:=
    proc(x:dom, y)

    begin
      if type(y)<>dom then
        FALSE
      else
        bool(sort([extop(x)])=sort([extop(y)]))
      end_if
    end_proc;
    
/* body of the domain */
  begin
    if args(0) <> 0 then error("wrong no of args") end_if;

    // local methods


    normalize:=
    proc(S)
      local result, i:DOM_INT;
    begin
      assert(extnops(S) >=1);
      result:=sort([extop(S)], (x,y)->sysorder(op(x,1), op(y,1)));
      i:=2;
      while i<=nops(result) do
        // test whether the i-th and the (i-1)th operand of the set
        // are equal and must be collected
        if result[i][1]=result[i-1][1] then
          result[i-1][2]:= result[i-1][2] + result[i][2];
          delete result[i]
        else
          i:=i+1
        end_if
      end_while;
      new(Dom::Multiset, op(result))
    end_proc;

    
  end_domain:
