//    
/*++
Dom::Natural -- the domain of natural numbers

A natural number is represented by an expression of type DOM_INT

Methods:-
convert(x)  - returns the value of x converted to Dom::Natural
numer(x)	   - returns the numerator of x
denom(x)	   - returns the denominator of x
testtype(x,T)      - returns TRUE if x is of type DOM_INT or DOM_RAT
min(x,...)	   - returns the minimal argument
max(x,...)	   - returns the maximal argument
++*/

domain Dom::Natural
  inherits Dom::Numerical;
  category Cat::AbelianGroup, Cat::OrderedSet;
    axiom Ax::canonicalRep, Ax::canonicalOrder,
      Ax::efficientOperation("_divide"), Ax::efficientOperation("_mult");
    
      testtype:=
      proc(x,T)
        begin
          if T <> Dom::Natural then return(FAIL) end_if ;
        if T = dom and domtype(x) = DOM_INT and x >= 0 then
          TRUE
        else
          FAIL
        end_if
      end_proc;

   convert:=
   proc(x)
   begin
     if domtype(x) = DOM_INT then
       x
     else
       FAIL
     end_if
   end_proc;

  
    // Semi ring entries; could mostly inherit from Dom::Integer, redefining
    // only those that are modified.

      _invert:=
      proc(n)
      begin
        if n=1 then 1 else FAIL end_if
      end_proc;

    _divide:= (i,j) -> if modp(i, j) = 0 then (i div j) else FAIL end_if;

      divides:= (i,j) -> bool(modp(j, i) = 0);
      
      isUnit:=
      proc(n)
      begin
        bool(n=1)
      end_proc;

      euclideanDegree:= abs;
      
      unitNormal:= abs;
      
      unitNormalRep:=
      proc(i)
      begin
        if i = 0 then
          [ 0, 1, 1 ]
        else
          [ abs(i), sign(i), sign(i) ]
        end_if
      end_proc;

    gcd:= igcd;

    gcdex:= igcdex;

    lcm:= ilcm;

    quo:= _div;

    rem:= modp;

    factor:= ifactor;

    irreducible:= isprime;

    divide:= (i,j) -> op([ i div j, modp(i, j) ]);

    
    randomGen:= table((0..999)=random(0..999));
    
    random:= proc(r) begin
        if args(0) = 0 then
            dom::randomGen[0..999]()
        else
            if not contains(dom::randomGen, r) then
                sysassign(dom::randomGen[r], random(r))
            end_if;
            dom::randomGen[r]()
        end_if
    end_proc;

    TeXrep := x -> "\\mathbb{N}";

  

end_domain:

