//    

/*++
Dom::SubSet (superset) - domain of subsets of superset
            


Subsets are given by
                           
                           
- a condition such that an element of the superset is
  in the given subset iff it satisfies that condition

- a parameter in the condition

++*/

domain Dom::SubSet(superset)
   
   
  inherits Dom::BaseDomain;
  category Cat::Set;
    // no axioms 
   
   // entries 
   

   // slots 

    condition:= S -> extop(S,1);
    
    variable:= S -> extop(S,2);
   
    convert :=
    proc(x)
      local inds;
      
    begin
      if testargs() then
        if args(0)>2 or args(0)=0 then
          error("Wrong number of arguments")
        end_if;
      end_if;
      if args(0)=2 then
        if type(args(2))<>DOM_IDENT then
          return(FAIL)
        end_if;
        return(new(dom,args()))
      end_if;
      case domtype(args(1))
        of dom do
          return(args(1))
        of DOM_EXPR do // test whether expression is boolean ?! 
          inds:=indets(x);
          if nops(inds)<>1 then
            FAIL
          else
            return(new(dom,args(1), op(inds)))
          end_if
      end_case;
      FAIL
    end_proc;

    changevar:=
    proc(S: dom, newvar)
    begin
      extsubsop(S, 1=subs(dom::condition(S), dom::variable(S)=newvar),
                2=newvar)
    end_proc;
     
    homog_union:=
    proc()
      local arglist, x;
    begin
      if args(0)=1 then return(args(1)) end_if;
      arglist:=[args()];
      if nops({op(map(arglist, dom::variable))})=1 then
        // all conditions use the same variable 
        new(dom, _or(op(map(arglist, dom::condition))),
            dom::variable(arglist[1]))
      else
        x:=genident();
        arglist:=map(arglist, dom::changevar, x);
        new(dom, _or(op(map(arglist, dom::condition))), x)
      end_if
    end_proc;
     
    homog_intersect:=
    proc()
      local arglist, x;
    begin
      if args(0)=1 then return(args(1)) end_if;
      arglist:=[args()];
      if nops({op(map(arglist, dom::variable))})=1 then
        // all conditions use the same variable 
        new(dom, _and(op(map(arglist, dom::condition))),
            dom::variable(arglist[1]))
      else
        x:=genident();
        arglist:=map(arglist, dom::changevar, x);
        new(dom, _and(op(map(arglist, dom::condition))), x)
      end_if
    end_proc;
     

    _minus:=
    proc(S,T)

    begin
      if type(S)=dom and type(T)=dom then
        new(dom, extop(S,1) and not subs(extop(T,1),extop(T,2)=extop(S,2)),
            extop(S,2))
      else
        hold(_minus)(S,T)
      end_if
    end_proc;

    homog_plus :=
    proc()
      local varlist:DOM_LIST;
    begin
      if args(0)=1 then
        args(1)
      else
        varlist:=[genident() $i=1..args(0)];
        Dom::ImageSet(_plus(op(varlist)), varlist, [args()])
      end_if
    end_proc;


     /*
   "_mult" = 

   "_power" = 

   */
  

    expr :=
    proc()
    begin
      extop(args(1),1)
    end_proc;

     // isEmpty: missing


    // overload _in
    
    set2expr:=
    proc(S:dom, x)
      
    begin
      if args(0)<>2 then
        error("Wrong number of arguments")
      end_if;
      subs(dom::condition(S), dom::variable(S)=x) and
      _in(x, superset)
    end_proc;

   
     
    print :=
    proc(S)
   
    begin
      "{ ".expr2text(extop(S,2))." in ".expr2text(superset)." ; ".
      expr2text(extop(S,1)). "}"
    end_proc;


  begin
    if args(0)<>1 then
      error("Wrong number of arguments")
    end_if;
    userinfo(20, "Constructing domain Dom::SubSet(".expr2text(superset).")")
  end_domain:





