//    
// kg, 19/09/95 

/*++
fp::curry -- curry n-ary function

fp::curry(f, [n])
f - function
n - non-negative integer (default is 2)

Given the funtion f: (x1,...,xn) +-> f(x1,...,xn) curry(f,n) returns 
the function
	() +-> f()    if n = 0,
	x1 +-> (x2 +-> ... (xn +-> f(x1, x2,... xn))...)    if n > 0.
++*/
fp::curry:= proc(f, n=2:Type::NonNegInt) 
  option escape; 
begin
  if testargs() then
    case args(0)
      of 1 do
      of 2 do
        break;
      otherwise
        error("Wrong number of arguments");
    end_case;
  end_if;

  case n
    of 0 do
    of 1 do
      f;
      break;
    of 2 do
      proc() 
        option escape; 
        local a; 
      begin
        a:= args();
        proc() 
        begin 
          f(a, args());
        end_proc;
      end_proc;
      break;
    otherwise
      fp::curry(fp::curry(f, n-1), 2);
  end_case;
end_proc:


/*--
fp::fix1st -- fix the first argument of a function

fp::fix1st(f, e)
f - function
e - expression

Given f: (x,y1,...yn) +-> f(x,y1,...yn) and e, fp::fix1st(f, e) 
returns the function
	(y1,...yn) +-> f(e,y1,...yn)
--*/

/*-- NEW IMPLEMENTATION, BUT NOT USED: to verify
fp::fix1st:= proc(f) option escape; local a; begin
    a:= args(2..args(0));
    proc() begin f(a, args()) end_proc
end_proc:
--*/

// end of file 
