// kg, 26/06/96 

/*++
fp::expr_unapply -- create a functional expression from an expression

fp::expr_unapply(e, [x1,...,xn])

e         - expression, regarded as function of x1,...,xn
x1,...,xn - (optional) indeterminates

fp::expr_unapply views the expression e as a function of the indeterminates
x1,...,xn and tries to return a functional expression computing that
function. If this is not possible FAIL is returned. If no indeterminates
are given, any indeterminates of e found by indets are used.

Examples:

fp::expr_unapply(sin(x), x)		-> sin
fp::expr_unapply(x+y, y, x)		-> _plus
fp::expr_unapply(2*x^2+1)		-> 2 * id^2 + 1
fp::expr_unapply(f(a,b), a, b)	-> f
fp::expr_unapply(f(a,b), a)		-> FAIL
++*/

fp::expr_unapply:=
proc(e)
  local opX, i, f, mkfunc;
begin
  if testargs() then
    if args(0) < 1 then
      error("Wrong number of arguments")
    end_if;
    if args(0) > 1 then
      opX:= { args(i) $ i=2..args(0) };
      // if (nops(opX) <> args(0) - 1) or (opX <> indets(opX)) then
      if map(opX, testtype, Type::Indeterminate) <> {TRUE} then
        error("Wrong indeterminates")
      end_if
    end_if
  end_if;

  // get indeterminates
  if args(0) = 1 then
    opX:= op(indets(e) minus Type::ConstantIdents)
  else
    opX:= args(2..args(0))
  end_if;

  // change expression to functional expression
  mkfunc:=
  proc(e)
    local t, i;
  begin
    t:= domtype(e);
    case t
      of DOM_EXPR do
        if op(e) = opX then
          op(e, 0);
          return(eval(%));
        end_if;
        // uncommented, produces chaos if e=x^x and opX=x
        /* if { op(e) } = { opX } then
          op(e,0);
          eval(%);
          if e = (%)(opX) then return(%) end_if
        end_if; */
        case type(e)
          of "_plus" do
            t:= 0;
            for i in e do
              i:= mkfunc(i);
              if i = null() then 
                return(null()) 
              end_if;
              t:= t + i
            end_for;
            return(t);
          of "_mult" do
            t:= 1;
            for i in e do
              i:= mkfunc(i);
              if i = null() then
                return(null());
              end_if;
              t:= t * i
            end_for;
            return(t);
          of "_power" do
            t:= mkfunc(op(e,1));
            if t = null() then 
              return(t); 
            end_if;
            if nops((indets(op(e,2)) minus Type::ConstantIdents) intersect {opX}) <> 0 then
              return(null());
            end_if;
            return(t^op(e,2));
        end_case;
        if nops(e) = 1 then
          t:= mkfunc(op(e,1));
          return((if t = null() then
                    null()
                  else
                    eval(op(e, 0)) @ t
                  end_if));
        end_if;
        return(null());
      of DOM_IDENT do
        return((if e = opX then
                  id
                elif contains(Type::ConstantIdents, e) then
                  e
                else
                  null()
                end_if));
    end_case;
    if contains({ DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX, DOM_STRING, DOM_BOOL, DOM_NIL, DOM_NULL }, t) then
      e
    else
      null()
    end_if
  end_proc;

    // create functional expression 
  f:= mkfunc(e);
  delete mkfunc;
  if f = null() then 
    FAIL 
  else 
    f;
  end_if;
end_proc:

// end of file 
