//    
// kg, 19/09/95 

/*++
fp::fixargs -- create function by fixing all but one argument

fp::fixargs(f, n, [e...])
f - function
n - positive integer <= args(0)-1
e - expression

fixargs curries f and then applies the curried version to the arguments
e[i]. The resulting function is returned.

fixargs(f,n,e[1],...,e[m]) returns the function 
	x +-> f(x)    if m=0
	x +-> f(e[1],..., e[n-1], x, e[n],... e[m])    if m > 0
++*/

fp::fixargs:= proc(f, n) 
  option escape; 
  local e1, e2; 
begin
  if testargs() then
    if args(0) < 2 then 
      error("Wrong number of arguments");
    end_if;
    if not testtype(n, Type::PosInt) then
	    error("Positive integer expected as second argument");
    end_if;
    if n > args(0)-1 then
	    error("Invalid argument position");
    end_if;
  end_if;
  if args(0) = 2 then
    f;
  else
	  if (n = 1) then
	    e2:= args(3..args(0));
	    proc(e) begin f(e, e2) end_proc
	  elif (n = args(0)-1) then
	    e1:= args(3..args(0));
	    proc(e) begin f(e1, e) end_proc
	  else
	    e1:= args(3..(n+1));
	    e2:= args((n+2)..args(0));
	    proc(e) begin f(e1, e, e2) end_proc
	  end_if;
  end_if;
end_proc:

// end of file 
