//    
// kg, 19/09/95 

/*++
fp::nest -- repeated composition of function

fp::nest(f, n)
f - function
n - non-negative integer

nest(f,n) returns the function x +-> f(f(...f(x)...)) where the
composition of f is n-fold repeated. I.e. nest is the function
	(f,0) +-> id,
	(f,n) +-> f @ nest(f, n-1) for n > 0.
++*/

fp::nest:= proc(f, n) option escape; begin
    if testargs() then
      if args(0) <> 2 then 
        error("Wrong number of arguments");
      end_if;
      if not testtype(n, Type::NonNegInt) then
        error("Non-negative integer expected as second argument");
      end_if
    end_if;
    
    case n
      of 0 do return(id);
      of 1 do return(f);
    end_case;
      
    proc() 
    begin 
      _fconcat(f $ n)(args());
    end_proc;
end_proc:

// end of file 
