//    
// kg, 19/09/95 

/*++
fp::nestvals -- repeated composition returning intermediate values

fp::nestvals(f, n)
f - function
n - non-negative integer

nestvals(f,n) returns the function x +-> [x, f(x),...f(f(...f(x)...))]
where the composition of f is 0- to n-fold repeated. I.e. nestvals is the 
function
	(f,n) +-> [nest(f,i) $ i=0..n]
++*/

fp::nestvals:= proc(f, n) 
  option escape; 
begin
  if testargs() then
    if args(0) <> 2 then 
      error("Wrong number of arguments");
    end_if;
    if not testtype(n, Type::NonNegInt) then
      error("Non-negative integer expected as second argument");
    end_if;
  end_if;

  case n
    of 0 do 
      return(proc() begin [args()] end_proc);
    of 1 do 
      return(proc() begin [args(), f(args())] end_proc);
  end_case;
    
  proc() 
    local i, r; 
  begin
	  r:= [args(), f(args())];
	  for i from 2 to n do
	    r:= append(r, f(op(r, nops(r))));
	  end_for;
	  r;
  end_proc;
end_proc:

// end of file 
