/*--
fortran.mu: FORTRAN code generator
--*/

/*++
generate::Fdefaults -- defaults of the FORTRAN code generator
++*/
if generate::Fdefaults = FAIL then
   generate::Fdefaults:= table(
     "Language"                = "FORTRAN",    // holds name of language to be exported
     "NameOfTimeVariable"      = "t",          // holds name of the 'time variable', e.g. used in derivatives
     "RenameTimeVariableTo"    = "t",          // rename 'time variable' identifiers to...
     "Warnings"                = TRUE,         // display warnings: TRUE or FALSE?
     "SubsLeftEqualByAssign"   = TRUE,         // statement: rewrite 'a = ...' to 'a := ...'?
     "AutoAddAssign"           = TRUE,         // statement: rewrite '...' to 'a := ...'?
     "AutoAddAssignPiecewise"  = FALSE,        // piecewise->if: automatically generate assignments in if-branches?
     "AutoBindToVarPiecewise"  = FALSE,        // piecewise: ident pw is piecewise => generate assignment pw:= ...?
     "UnwrapOde"               = FALSE,        // extract ode and initial conditions from ODE object?
     "ReduceOrderOfDerivaties" = FALSE,        // reduce higher order derivatives to first order derivatives?
     "IndentInitial"           = "      ",     // initial indent of first line
     "IndentInitialContinue"   = "     +",     // initial indent of next  lines (if wrapped)
     "IndentWidth"             = "  ",         // holds spaces to indent code lines
     "IndentLevel"             = 0,            // indent:= IndentLevel * IndentWidth
     "StatementDelimiter"      = "",           // delimiter that terminates a statement
     "Digits"                  = 16,           // number of digits for floating point numbers
     "IntAsIntWhereObvious"    = FALSE,        // export an integer as integer instead of double?
     "IntToFloat"              = FALSE,        // converts *all* integer in input to floating point numbers
     "DoubleFormat"            = "e",          // see Pref::floatFormat
     "DoubleEnotationChar"     = "D",          // char in floating point numbers: 10.0 = 1.0E1
     "Inf"                     = "INF",        // representation of INF (infinity)
     "NaN"                     = "NaN",        // representation of NaN (not a number)
     "True"                    = ".TRUE.",     // representation of the boolean value true
     "False"                   = ".FALSE.",    // representation of the boolean value false
     "Unknown"                 = FAIL,         // representation of the boolean value unknown
     "ComplexI"                = FAIL,         // representation of complex value I (=i) or FAIL
     "ComplexPrefix"           = "",           // prefix of complex numbers: not yet supported
     "PowerOperator"           = "**",         // power operator, e.g. "^" or "**", or FAIL
     "PowerThreshold"          = 1,            // write as product if exponent is less or equal
     "PowerInvertNegIntRatExp" = TRUE,         // rewrite x^-rat to 1/x^rat?
     "PowerKeepIntExp"         = TRUE,         // keep x^int rather than converting to x^float?
     "Log2"                    = FAIL,         // name of log(2,x) function or FAIL
     "Log10"                   = "log10",      // name of log(10,x) function or FAIL
     "ReturnType"               = "double",     // always create "int" or "double" objects
     "TypeChecking"            = FALSE,        // do type checking while creating objects
     "OnUnverifiedName"        = "warning",    // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "OnRequiresFORTRAN_77"    = FAIL,         // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "OnRequiresFORTRAN_90"    = FAIL,         // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "OnRequiresFORTRAN_95"    = "warning",    // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "OnRequiresFORTRAN_2003"  = "warning",    // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "OnRequiresFORTRAN_2008"  = "warning",    // "warning", "error" or FAIL. Warning/error on unsupported functions.
     "NameOfScalar"            = "t",          // basename of scalar variables | ,"_" to avoid ::optimize conflict?
     "NameOfArray"             = "A",          // basename of array variables
     "NameOfFunction"          = "fun",        // basename of functions
     "NameOfDerivative"        = "x",          // basename of derivatives
     "DerivativeVectorNotation"= FALSE,        // identifier for derivatives use vector notation?
     "NameIndexFirst"          = 0,            // first index in names of variables and functions
     "NameIndexFirstDerivative"= 1,            // first index in names of derivatives
     "NameIndexDigits"         = 0,            // 0 or min. digits of the index in names, to be filled up with leading 0s
     "GenSparseMatrix"         = TRUE,         // generate sparse matrix: TRUE / FALSE.
     "Convert1x1MatrixToScalar"= FALSE,        // convert 1x1 matrix to scalar expression: TRUE / FALSE.
     "GenerateMatrixStyle"     = "FORTRAN",    // e.g. A0(1,1) = 1  A0(1,2) = 2  A0(2,1) = 4  A0(2,2) = 5
     "IndexLeft"               = "(",          // e.g. x(1)
     "IndexRight"              = ")",          // e.g. x(1)
     "IndexStyle"              = "Fortran",    // A[?,?] => A(?,?)
     "ContinueEnumeration"     = FALSE,        // set variable index counters to zero?
     "SupportProcedures"       = FALSE,        // support (experimental) export of DOM_PROC?
     "MathConstants"           = table(        // mathematical constants
                                   hold(CATALAN) = table("type"="double", "value"=float(CATALAN)),
                                   hold(E)       = table("type"="double", "value"=hold(exp(1.0))), 
                                   hold(EULER)   = table("type"="double", "value"=float(EULER)), 
                                   hold(PI)      = table("type"="double", "value"=float(PI)), // acos(0.0D0) = pi/2
                                   null()
                                 ),
     null()
   ):
end_if:

/*++
generate::fortran -- FORTRAN code generator : returns a FORTRAN formatted character string
generate::fortran(e)
  e - expression, equation or list of equations
++*/
generate::fortran:= proc() 
   option hold;
begin
   if args(0) = 0 then
     return("");
   end_if;
   context(hold(generate::CF)(args(1), [args(2..args(0))], generate::Fdefaults)); // magic :-)
end_proc:

// end of file 
