alias(Maple=generate::maple): 
alias(Seq=generate::maple_seq):

Maple := proc(e) 
   option remember;
begin
   if e::dom::maple<>FAIL then 
      return(e::dom::maple(args()));
   end_if;
   expr2text(e);
end_proc:
 
Maple(PI):="Pi":
Maple(EULER):="gamma":
Maple(CATALAN):="Catalan":

// method "maple" for other domains 
DOM_INT::maple:= () -> ((
   expr2text(args(1)); 
   if args(1)>=0 then
      % 
   else 
      "(".%.")"
   end_if
)):

DOM_EXPR::maple:=proc(e) 
   local t;
begin
   t:=eval( op(e,0) );
   if domtype(t) = DOM_FUNC_ENV then
      t:= slot(t,"maple");
      if t<>FAIL then 
         return(t(op(args())));
      end_if
   elif type(e)="function" then 
      return(Maple(op(e,0))."(".Seq(e,",").")");
   end_if;
   expr2text(e);
end_proc:

/* Seq([a,b,c],",") -> "a,b,c"
   Seq([a,b,c],";") -> "a;b;c" */
Seq:=proc(l,s) 
   local i;
begin
   if nops(l)=0 then 
      ""
   else 
      Maple(op(l,1)).(s.Maple(op(l,i)) $ i=2..nops(l));
   end_if
end_proc:

DOM_PROC::maple:=proc(p)
  local vars;
begin
   "proc(".(if op(p,1)=NIL then "" else Seq([op(p,1)],",") end_if).") ".
   (if op(p,2)=NIL then "" else "local ".Seq([op(p,2)],",")."; " end_if).
   (if op(p,3)=NIL then "" else "option ".Seq([op(p,3)],",")."; " end_if).
   (vars:= ["this", (if op(p,2)=NIL then null() else op(p,2) end), op(p,1)];
            Maple(misc::maprec(op(p,4), {DOM_VAR} = (e -> (
                        if op(e,1) = 0 then //local context
                           op(vars, op(e,2));
                        else
                           e;
                        end_if;
            ))))).
   " end"
end_proc:

// Convert to an expressions since Maple has no aquivalent
DOM_POLY::maple:= expr:

// function attributes 
_plus:=slot(_plus,"maple",(()->("(".Seq([args()],"+").")"))):

_mult:=slot(_mult,"maple",(()->("(".Seq([args()],"*").")"))):

_power:=slot(_power,"maple",(()->(Maple(args(1))."^(".Maple(args(2)).")"))):

_stmtseq:=slot(_stmtseq,"maple",(()->(Seq([args()],"; ")))):

_if:=slot(_if,"maple",(()->("if ".Maple(args(1))." then ".Maple(args(2)).
   (if args(3)=NIL then "" else " else ".Maple(args(3)) end_if)." fi"))):
