/**
  generate::isNeg  :  

  Domains with own representation which may contain signed values
  have to provide a isNeg method in order to produce good looking 
  outputs.  In order to check some operands of an element these
  methods may call this function.


  WARNING:  This is a library equivalent of an internal kernel
            function.  Changes have to be done in MIO_is_neg as
            well !!!
*/
generate::isNeg :=
proc(x) : DOM_BOOL
  local isneg, re, negate;
 // option noDebug;
begin
  negate := x::dom::_negate;
  if (isneg := x::dom::isNeg) <> FAIL and negate <> FAIL then
    return(isneg(x));
  end_if;
  
  case x::dom
    of DOM_INT do
    of DOM_RAT do
    of DOM_FLOAT do
       return(bool(x<0));

    of DOM_COMPLEX do
       re := op(x,1);
       if not iszero(re) then
         return(bool(re<0));
       end_if;
       return(bool(op(x,2)<0));

    of DOM_EXPR do
       case type(x) 
         of "_negate" do
            return(TRUE);

         of "_plus" do
            return(generate::isNeg(op(generate::sortSum(x), 1)));

         of "_mult" do
            if contains({DOM_COMPLEX, DOM_FLOAT, DOM_INT, DOM_RAT}, 
                        domtype(op(x, nops(x)))) then
               return(generate::isNeg(op(x, nops(x))));
            end_if;
            if contains({DOM_COMPLEX, DOM_FLOAT, DOM_INT, DOM_RAT}, 
                        domtype(op(x, 1))) then
               return(generate::isNeg(op(x, 1)));
            end_if;
            return(FALSE);
       end_case;
  end_case;
  FALSE
end_proc:

generate::isNeg(RD_NAN) := FALSE:


/**
  generate::negate  :  


  If generate::isNeg returns TRUE for an expression, generate::negate
  can be used to get rid of the minus-sign.  In contrast to simply
  calling _negate, genrate::negate does not do any simplifications,
  which is necessary for the output of unsimplified expressions.

  WARNING:  This is a library equivalent of an internal kernel
            function.  Changes have to be done in MIO_negate as
            well !!!
*/
generate::negate :=
proc(ex)
  local len, value, res, trailingZeroes, outputDigits, floatFormat, numbers;
  save DIGITS;
begin
  
  if contains({DOM_FLOAT, DOM_COMPLEX, "_mult"}, type(ex)) and
     stdlib::hasfloat(ex) then
    trailingZeroes := Pref::trailingZeroes(TRUE);
    outputDigits := Pref::outputDigits(InternalPrecision);
    floatFormat := Pref::floatFormat("e");
    numbers := select([op(ex)], testtype, DOM_FLOAT);
    if nops(numbers) > 0 then
      DIGITS := length(stringlib::subs(stringlib::split(expr2text(numbers[1]), "e")[1],
                                       "-"="", "."=""));
    end_if;
    Pref::trailingZeroes(trailingZeroes);
    Pref::outputDigits(outputDigits);
    Pref::floatFormat(floatFormat);
  end_if;
  
  if domtype(ex) = DOM_COMPLEX then
    return(-ex)
  end_if;
  
  if type(ex) = "_mult" then
    len := nops(ex);
    
    if testtype(op(ex, len), Type::Real) then
      // negate last number
      value := (-1)*op(ex, len);
      if value = 1 then
        res := hold(_mult)(op(ex, 1..len-1));
      else
        res := hold(_mult)(op(ex, 1..len-1), value);
      end_if;
      if nops(res) = 1 then
        // product contains only one factor
        res := op(res);
      end_if;
      return(res);
    elif testtype(op(ex, 1), Type::Numeric) then
      // negate first number
      value := (-1)*op(ex, 1);
      if value = 1 then
        res := hold(_mult)(op(ex, 2..len));
      else
        res := hold(_mult)(value, op(ex, 2..len));
      end_if;
      if nops(res) = 1 then
        // product contains only one factor
        res := op(res);
      end_if;
      return(res);
    elif generate::hasNormalForm(ex) and op(ex, len) <> I then
      return(hold(_mult)(op(ex), -1))
    else
      return(hold(_negate)(ex))
    end_if;
  end_if;
  
  if type(ex) = "_negate" then
    return(op(ex, 1))
  end_if;

  if type(ex) = "_divide" or type(ex) = "_power" then
    return(hold(_negate)(ex))
  end_if;

  _negate(ex)
end_proc:


/*--
 generate::sortExprWithDOrDiff -- handles the special case in sortSum, where
                                  the expression can be considered as an ODE
                                  written in terms of D or diff.
 Arguments: list -- the list of summands of the _plus-expression from sortSum
 Result: [list1,subst,bases] -- list1 is a list where D- and diff-expressions are
                                replaced by generated identifiers and subst is a
                                list containing the substitutions needed for
                                backtranslation. The substitution is made in a way
                                such that _plus(op(list1)) is a polynomial
                                expression which can be sorted with the ususal
                                polynomial sorting approach in sortSum.
                                bases is the ordered list of bases which should
                                be used as poly indeterminates later on.
--*/
generate::sortExprWithDOrDiff :=
proc(list)
  local DTerms, i, j, count, term, substitutions, Darg, diffTerms, diffVars,
        varCount, vars, prefix, replacePath, skip, terms, replaceTerm, pos,
        outerExpr, operatorSubst, DOargs, bases, other;
begin
  // first check for used variable names
  vars := map(indets(list, All), expr2text);
  // prefix is one # more than used in any identifier used in argument 'list'
  prefix := _concat(# $ max(map(map(vars, strmatch, "^#+", Index, All),
                                  op@op) union {0})+1);
  
  // replace funcenvs by idents, otherwise prog::find decends
  // far too deep and possibly runs into errors
  list := misc::maprec(list, {DOM_FUNC_ENV}=(x->if x::print <> FAIL then
                                                  if testtype(x::print, DOM_STRING) then
                                                    hold(``).x::print
                                                  else
                                                    x::print
                                                  end_if;
                                                else
                                                  hold(``).(expr2text(x))
                                                end_if));
  
  // first replace D-expressions
  DTerms := sort([prog::find(list, hold(D))], (x,y)->nops(x)<nops(y));
  substitutions := [];
  operatorSubst := [];
  Darg := {};
  DOargs := {};
  bases := {};
  
  // look for replacement candidates 
  for i from 1 to nops(DTerms) do
    count := 0;
    term := op(list, DTerms[i][1..-2]);
    // term is part of an existing replace candidate
    skip := FALSE;
    for j from 1 to i do
      if DTerms[j] = FAIL then next; end_if;
      if DTerms[j][1] = DTerms[i][1..nops(DTerms[j][1])] then
        DTerms[i] := FAIL;
        skip := TRUE;
        break;
      end_if;
    end_for;
    if skip or not testtype(term, "D") or nops(term) <> 1 then
      DTerms[i] := FAIL;
      next;
    end_if;
    // count number of D's in D(D(D(...D(f))))
    while testtype(term, "D") and nops(term) = 1 do
      count := count + 1;
      term := op(term);
    end_while;
    // look if the D-expression is 0th operand of an expression
    outerExpr := op(list, DTerms[i][1..-3]);
    if testtype(outerExpr, DOM_EXPR) and
       op(outerExpr, 0) = op(list, DTerms[i][1..-2]) then
      Darg := Darg union {term(op(outerExpr))};
      // store path to term and term for later replacement
      DTerms[i] := [DTerms[i][1..-3], prefix."D".term."'".op(outerExpr)."_".count];
    else
      // we have a operator notation like f''+f'+g'
      outerExpr := op(list, DTerms[i][1..-2]);
      DTerms[i] := [DTerms[i][1..-2], prefix."o".term."_".count];
      DOargs := DOargs union {term};
    end_if;
  end_for;
  
  // do the replacements for D-expressions
  for i from 1 to nops(DTerms) do
    if DTerms[i] = FAIL or
       // we already replaced this term in this loop
       not testtype(op(list, DTerms[i][1]), DOM_EXPR) then next; end_if;
    // substitute D(f) by #Df1, etc
    [replacePath, term] := DTerms[i];
    bases := bases union {term};
    
    substitutions := substitutions.[term=op(list, replacePath)];
    list := subsop(list, replacePath=term, Unsimplified);
  end_for;

  // now substitute f(x) by #Df0, etc.
  if Darg <> {} then
    Darg := [op(Darg)];
    terms := map(Darg, x -> prefix."D".op(x,0)."'".op(x)."_".0);
    // happens if f'(x) and f'(y) occur in mn expression
    substitutions := substitutions.zip(terms, Darg, _equal);
    bases := bases union {op(terms)};
    list := subs(list, op(zip(Darg, terms, _equal)), Unsimplified);
  end_if;
  
  if DOargs <> {} then
    // DOargs contains the used base args of D, like g in D(g). Replace it by the
    // same substitution variable for better sorting (e.g the g in g' + g).
    bases := bases union map(DOargs, x -> prefix."o".x."_".0);
    DOargs := [op(DOargs)];
    list := subs(list, map(DOargs, x -> x=prefix."o".x."_".0));
    substitutions := substitutions.map(DOargs, x -> prefix."o".x."_".0=x);
  end_if;
  
  // and now look for diff-expressions
  diffTerms := sort([prog::find(list, hold(diff))], (x,y)->nops(x)<nops(y));
  for i from 1 to nops(diffTerms) do
    term := op(list, diffTerms[i][1..-2]);
    if not testtype(term, "diff") then next; end_if;
    // replace diff(f(x,y), x, y) by #d1*#Vx2
    diffVars := [op(term, 2..nops(term))];
    
    vars := {op(diffVars)};
    for j in vars do
      [varCount, diffVars, other] := split(diffVars, _equal, j);
      diffVars := [prefix."V".j."_".nops(varCount)].diffVars;
      bases := bases union {prefix."V".j."_".nops(varCount)};
    end_for;

    // diffVars can now be #Vx2
    // pick the operands from diffVars and plug them in a held _mult
    substitutions := [hold(_mult)(prefix."d_".i, op(diffVars))=term /*,
                      prefix."d".i=hold(_mult)(term,
                                               op(map(diffVars, _power, -1)))*/].
                   substitutions;
    replaceTerm := op(list, diffTerms[i][1..-3]);
    if testtype(replaceTerm, "_mult") then
      pos := contains([op(replaceTerm)], op(list, diffTerms[i][1..-2]));
      list := subsop(list,
                     diffTerms[i][1..-3]=hold(_mult)(op(replaceTerm, 1..pos-1),prefix."d_".i,
                                                     op(diffVars), op(replaceTerm, pos+1..nops(replaceTerm))),
                   Unsimplified);
    else
      list := subsop(list,
                     diffTerms[i][1..-2]=hold(_mult)(prefix."d_".i, op(diffVars)),
                     Unsimplified);
    end_if;
  end_for;
  
  return([list, substitutions,
          DOM_SET::sort(bases, proc(x,y)
                                 local idx, xCount, yCount;
                               begin
                                 x := "".x;
                                 idx := max(map(strmatch(x, "_", Index, All), op));
                                 xCount := text2expr(x[idx+1..-1]);
                                 x := x[1..idx];
                                 y := "".y;
                                 idx := max(map(strmatch(y, "_", Index, All), op));
                                 yCount := text2expr(y[idx+1..-1]);
                                 y := y[1..idx];
                                 if length(x) <> length(y) then
                                   sysorder(x, y);
                                 elif x = y then
                                    xCount > yCount;
                                 else
                                   sysorder(x, y);
                                 end_if
                               end_proc)]);
end_proc:

/*--
generate::sortSum  --  rearranges the succession of the summands in
                       a sum. The first summand is positive if
                       possible. 

generate::sortSum( SUM )

       SUM  --   a "_plus"- expression

Puts the first nonnegative summand in the first position of
the sum.

>> -a*b*3-c*d*(-2);

                              - 3 a b + 2 c d

>> generate::sortSum(%);

                               2 c d - 3 a b

This function is used by generate::TeX and by the
typesetting system for determining the output order of terms of a
_plus-expression.

--*/
generate::sortSum :=
proc(SuM)
  local i, list, lastOp, keepOrder, bases, p, prMonomial, res, endIdx, f, SUM,
        substitutions, newBases, normalizeMult;
  save DIGITS;
//  option noDebug;
begin
  normalizeMult := proc(m)
                     local pos, numbers;
                   begin
                     assert(testtype(m, "_mult"));
                     if nops(m) = 1 then
                       return(op(m));
                     end_if;
                     numbers := select([op(m)], testtype, Type::Numeric);
                     if nops(numbers) = 1 then
                       pos := contains([op(m)], numbers[1]);
                       if pos < nops(m) then
                         m := hold(_mult)(op(m, 1..pos-1), op(m, pos+1..nops(m)), op(m, pos));
                       end_if;
                     end_if;
                     m
                   end_proc;

  if not testtype(SuM, "_plus") then
    assert(FALSE);
    return(SuM);
  end_if;
  if nops(SuM) = 1 then
    return(SuM);
  end_if;
  
  keepOrder := Pref::keepOrder();
  if keepOrder = hold(Always) or
     keepOrder = hold(DomainsOnly) and _domainOutputMode = TRUE or
     SuM <> extsubsop(SuM, 1=extop(SuM,1)) then
    return(SuM)
  end;

  res := FAIL;
  substitutions := FAIL;
  traperror((
  list := [op(SuM)];
  lastOp := op(list, nops(list));
  if has(lastOp, I) then
    if domtype(lastOp) = DOM_COMPLEX and
       op(lastOp, 1) <> 0 and op(lastOp, 1) <> 0.0 then
      list := [op(SuM, 1..nops(list)-1), op(lastOp,1), I*op(lastOp,2)]
    end_if
  elif has(list, I) then
    // no complex number at the end, but in the expression;
    // possibly something like  'a+b*I'
    endIdx := nops(list) - 1;
    for i from 1 to endIdx do
      if testtype(list[i], "_mult") and
         contains(map({op(list[i])}, domtype), DOM_COMPLEX) then
        // we have found something like b*I
        list := list[1..i-1].list[i+1..nops(list)].[list[i]];
        endIdx := endIdx - 1;
      end_if
    end_for
  end_if;
  // we float below and the output order should not depend on DIGITS
  // DIGITS := 3;
             
  // if list contains a power, we want a polynomial like output
  // I don't remember what the float(list) was good for. Leaving out float here
  // reduced the runtime of the pathologic example in g509376 even further
  // from 40 seconds to 4 seconds.
//  if traperror((f := has(float(list), hold(_power))), MaxSteps = 1) = 0 and
  if traperror((f := has(list, {hold(_power), hold(D), hold(diff)})), MaxSteps = 1) = 0 and
     f = TRUE then
    f := FAIL;
    // get all bases of powers
    bases := DOM_SET::sort(indets(map(select({op(map(list, op)), op(list)}, testtype, "_power"), op, 1), RatExpr) minus Type::ConstantIdents);
//    bases := select(bases, testtype, Type::Union(DOM_IDENT, "_index"));
    if traperror((f := has(list, {hold(D), hold(diff)})), MaxSteps = 1) = 0 and
       f = TRUE then
      newBases := [];
      // replace D and diff-expressions to get a polynomial for sorting
      traperror(([list, substitutions, newBases] :=
                 generate::sortExprWithDOrDiff(list)));
      bases := newBases.bases;
//      print(Plain, "trying to sort", list, "wrt. order", bases);
//      print(Plain, "... and  back subst", substitutions);
    end_if;
    if bases = [] or nops(list) = 2 and
      map({op(list)}, generate::isNeg) = {TRUE, FALSE} then
      p := FAIL
    else
      SUM := numeric::rationalize(hold(_plus)(op(list)));
      if testtype(SUM, Type::PolyExpr(bases)) then
        p := FAIL;
        traperror((p := poly(SUM, numeric::rationalize(bases))), MaxSteps=1);
        if expr(p) = SUM and
           {op(expr(p))} = {op(numeric::rationalize(list))} then
          p := poly2list(hold(_plus)(op(list)), bases);
        else
          p := FAIL;
        end_if;
      else
        p := FAIL;
      end_if;
    end_if;
    if p <> FAIL and indets(map(p, op, 1)) intersect {op(bases)} = {} then
      prMonomial :=
      proc(m)
        local c, pow;
      begin
        if m[1] = 1 then
          c := null();
        else
          c := m[1]
        end_if;
        pow := null();
        for i from 1 to nops(m[2]) do
          case op(m[2], i)
            of 0 do
              // c*x^0
              break;
              
            of 1 do
              pow := pow, bases[i];
              break;
              
            otherwise
              pow := pow, hold(_power)(bases[i], op(m[2], i));
          end_case;
        end_for;
        if c = null() and pow = null() then
          c := 1;
        end_if;
        if nops([c, pow]) = 1 then
          c := c, pow;
          if type(c) = "_plus" then
            op(c)
          else
            c
          end_if
        else
          if testtype(c, Type::Numeric) then
            hold(_mult)(pow, c)
          elif type(c) = "_mult" then
            if testtype(op(c, nops(c)), Type::Numeric) then
               hold(_mult)(op(c, 1..nops(c)-1), pow, op(c, nops(c)))
           else
              hold(_mult)(op(c), pow)
            end_if
          else
            hold(_mult)(c, pow)
          end_if
        end_if;
      end_proc:
      res := hold(_plus)(prMonomial(p[i]) $ i = 1..nops(p))
    end_if
  end_if;

  if res = FAIL and generate::isNeg( op(list,1)) then
    for i from 2 to nops(list) do
      if res = FAIL and 
         not has(op(list, i), I) and 
         not generate::isNeg(op(list, i)) then
        res := hold(_plus) (op(subsop(list, 1=op(list, i), i=op(list, 1), Unsimplified)));
      end_if;
    end_for;
  end_if;
  if res = FAIL then
    res := hold(_plus)(op(list));
  end_if;
  ), MaxSteps = 1);

  if res <> FAIL then
    if substitutions <> FAIL then
//      print(Plain, "applying subst on", res);
      // the substitutions from sortExprWithDOrDiff have to be taken back
      res := subsex(res, op(substitutions), Unsimplified);
      misc::maprec(res, {"_mult"} = normalizeMult, Unsimplified);
    else
      res
    end_if;
  else
    SuM
  end_if
end_proc:

generate::sortSums :=
proc(ex)
  local ex2;
begin
  if ex::dom::sortSums <> FAIL then
    return(ex::dom::sortSums(ex))
  end_if;
  if Pref::keepOrder() = Always then ex
  else
    ex2 := misc::maprec(ex,
                        (x->testtype(x, "_plus"))
                        = generate::sortSum, Unsimplified);
    // Do not write '-a-b' as '-(a+b)' at top level.
    if op(ex2, 0) = hold(_mult)
      and nops(ex2) = 2
      and op(ex2, [1, 0]) = (_plus)
      and op(ex2, 2) = -1 then
      ex
    else
      ex2
    end_if;
  end_if
end_proc:

