/*- 
 addVertices - adds one or several vertices to a Graph
 addVertices(G, Vertex)
 addVertices(G, Vertex, VertexWeights=n)
 addVertices(G, [v1,..,vn])
 addVertices(G, [v1,..,vn], VertexWeights=[c1,..cn])
 Parameters:
   G             - Graph
   Vertex        - a list of one or more vertices
   VertexWeights - a list of one or more vertice weights
                   If no Weight was specified, the Weight is set to 1 (in order to work with some algorithms)
-*/
Graph::addVertices := proc(G : Graph, Vertex : DOM_LIST)
local _vertices, _correctVertices, _vertexWeights, leftOperator, rightOperator, x, position, _edgesLeaving, _edgesEntering;
begin
  if args(0) > 3 then
    error("Wrong number of arguments! See help for more details.")
  end_if;

  _correctVertices := Graph::selectVertex(G, Vertex, FALSE);
  _vertexWeights := FAIL;
  
  case args(0) 
    of 2 do
      _vertices := Graph::getVertices(G)._correctVertices;  // add list to existing vertices
      break;
    of 3 do
      if not (type(args(3)) = "_equal") then
        error("Wrong argument type: equation expected!");
      end_if;

      // Should be VertexWeights.
      leftOperator := op(args(3),1); 
      // Should be the list.
      rightOperator := op(args(3),2);

      if leftOperator <> hold(VertexWeights) then
        error("Wrong argument type " .expr2text(args(4)) . ". VertexWeights expected!");
      end_if;

      if nops(Vertex) <> nops(rightOperator) then
        error("Length of lists must be equal!");
      end_if;
      _vertices := Graph::getVertices(G)._correctVertices;
      _vertexWeights := Graph::getVertexWeights(G);
      // Check was already done and only not existing edges remain!
      for x in _correctVertices do
        position := contains(Vertex,x);
        if not op(rightOperator) = hold(None) then
          _vertexWeights[x] := rightOperator[position];              
        end_if;
      end_for;           
      break;
  end_case;

  _edgesLeaving := Graph::getEdgesLeaving(G);
  _edgesEntering := Graph::getEdgesEntering(G);

  for x in _correctVertices do
    _edgesLeaving[x] := [];
    _edgesEntering[x] := [];
  end_for;

  _vertices := sort(_vertices);

  subsop(G, 1=_vertices, 3=_vertexWeights, 7=_edgesEntering, 8=_edgesLeaving);
end_proc:

// End of file
null():

