/* checkForVertices: returns an empty list if all vertices from all edges exist in the vertice-list, 
                     the list with the wrongly used vertices otherwise.
   checkForVertices(Edge, Vertex)
   checkForVertices([e1..en], [v1..vn])

   Parameters:
   Edge - List of one or more edges
   Vertex - List of one or more vertices
*/
Graph::checkForVertices := proc(Edge : Type::ListOf(DOM_LIST), Vertex : DOM_LIST)
local tmpList, _newVertices, _existingVertices, _dummy;
begin

  if nops(Edge) = 0 then
    return ([]);
  end_if;

  // Get all vertices in one list
  tmpList:= op({_concat(op(Edge))});

  [_existingVertices, _newVertices,  _dummy] := split(tmpList, v -> contains(Vertex, v) > 0);

  if nops(_newVertices) > 0 then
    return ([op({op(_newVertices)})]);
  else
    return ([]);
  end_if;
end_proc:

// End of file
null():
