/*
Graph::chromaticNumber

Parameters:
G - Graph

computes the chromatic number of the graph G.
G must be undirected.

*/

Graph::chromaticNumber:=
proc(G: Graph): Type::PosInt
  local
  chromPoly: DOM_POLY,
  n: DOM_INT;  

begin
  if args(0) <> 1 then
    error("Wrong number of args")
  end_if;
  if Graph::isDirected(G) then
    error("Graph must be undirected!");
  end_if;
  
  chromPoly:= Graph::chromaticPolynomial(G, hold(X));

  n:= 0;
  repeat
    n:= n+1
  until not iszero(chromPoly(n)) end_repeat;
  n
end_proc: