/*-
 createGraphFromMatrix - generates a directed Graph from a matrix
 createCompleteGraph(n)
 Paramters:
   n - a matrix that is to be transferred to the graph structure.
-*/
Graph::createGraphFromMatrix := proc(matrix)
local i, j, n, _vertices, _edges, _edgeWeights;
begin
  if args(0) <> 1 then
    error("Wrong number of arguments!");
  end_if;

  if op(matrix::dom::matdim(matrix),1) <> op(matrix::dom::matdim(matrix),2) then
  	 error("Matrix must be squared!");
  end_if;
  n := op(matrix::dom::matdim(matrix),1);
  _vertices := [$1..n];
  _edges := [(([i,j] $ j=1..n)) $ i=1..n];
  _edgeWeights := [((matrix[i,j] $ j=1..n)) $ i=1..n];
  
  Graph(_vertices, _edges, EdgeWeights=_edgeWeights, Directed);

end_proc:

// End of file
null():
