/*
  createRandomEdgeWeights - creates random edge weights
  Parameters:
  G        - Graph
  range    - a range in between which the numbers have to be
  Real|Int - Either the numbers are integer or real.
*/
Graph::createRandomEdgeWeights := proc(G : Graph, range : "_range")
local _edges, edge, _edgeWeights, createNumber, i, domType;
begin
  createNumber := random(range);
  _edges := Graph::getEdges(G);
  domType := Dom::Integer;

  if args(0) = 3 then
    case args(3)
      of Dom::Real do
        domType := Dom::Real;
        break;
      of Dom::Integer do
        break;
      otherwise
        error("Wrong argument definition (try: Dom::Integer or Dom::Real)!");
    end_case;  
  end_if;

  if domType = Dom::Integer then
    for edge in _edges do
      i := createNumber();
      _edgeWeights[edge] := i;
    end_for;
  else
    for edge in _edges do
      i := createNumber();
      i := i + frandom();   
      _edgeWeights[edge] := i;
    end_for;
  end_if;
  subsop(G, 5=_edgeWeights);
end_proc:

// End of file
null():
