/*
  createRandomVertexWeights - creates random edge weights
  Parameters:
  G        - Graph
  range    - a range in between which the numbers have to be
  Real|Int - Either the numbers are integer or real.
*/
Graph::createRandomVertexWeights := proc(G : Graph, range : "_range")
local _vertices, vertex, _vertexWeights, createNumber, i, domType;
begin
  createNumber := random(range);
  _vertices := Graph::getVertices(G);
  domType := hold(Int);

  if args(0) = 3 then
    case args(3)
      of hold(Real) do
        domType := hold(Real);
        break;
      of hold(Int) do
        break;
      otherwise
        error("Wrong argument definition (try: Int or Real)!");
    end_case;  
  end_if;

  for vertex in _vertices do
     i := createNumber() $ 1;
     if domType = hold(Real) then
       i := i + frandom();
     end_if;
    _vertexWeights[vertex] := i;
  end_for;
  subsop(G, 3=_vertexWeights);
end_proc:

// End of file
null():
