/*-
 inDegree - vertex indegrees of a Graph. Graph must be directed !
 inDegree(G)
 inDegree(G, [v])
 inDegree(G, [v1,..,vn])
 Parameters:
   G - Graph
   v - vertices of G
-*/
Graph::inDegree := proc(G : Graph)
local i, _result, _vertices , _edgesEntering;
begin
  _vertices := Graph::getVertices(G);
  _edgesEntering := Graph::getEdgesEntering(G);
   
  case args(0)
    of 1 do
      return(table(_vertices[i] = nops(_edgesEntering[_vertices[i]]) $ i=1..nops(_vertices)));
    of 2 do
       if not testtype(args(2), DOM_LIST) then
         error("Wrong argument type: List expected!");
       end_if;

       _result := table();
       for i in args(2) do 
         if contains(_vertices, i) > 0 then
           _result[i] := nops(_edgesEntering[i]);
         else
           warning("Graph doesn't contain specified vertex " . i . "\n");
         end_if;
       end_for;

       _result;
       break;
    otherwise
      error("Wrong number of arguments! See help for more details.")
  end_case;
end_proc:

/*-
 outDegree - vertex outdegrees of a Graph. Graph must be directed !
 outDegree(G)
 outDegree(G, v)
 outDegree(G, [v1,..,vn])
 Parameters:
   G - Graph
   v - vertices of G
-*/
Graph::outDegree := proc(G : Graph)
local i, _result, _vertices , _edgesLeaving;
begin
  _vertices := Graph::getVertices(G);
  _edgesLeaving := Graph::getEdgesLeaving(G);
   
  case args(0)
    of 1 do
      return(table(_vertices[i] = nops(_edgesLeaving[_vertices[i]]) $ i=1..nops(_vertices)));
    of 2 do
       if not testtype(args(2), DOM_LIST) then
         error("Wrong argument type: List expected!");
       end_if;

       _result := table();
       for i in args(2) do 
         if contains(_vertices, i) > 0 then
           _result[i] := nops(_edgesLeaving[i]);
         else
           warning("Graph doesn't contain specified node " . i . "\n");
         end_if;
       end_for;
       return(_result);
    otherwise
      error("Wrong number of arguments! See help for more details.")
  end_case;
end_proc:

// End of file
null():
