/*
  getBestAdjacentEdge(G, Vertex, Vertices <, Weights|Costs> <, Min|Max> )
  returns the shortest/longest way from the given vertex to any of the adjacent ones. 
  If no adjacent edge exist, FAIL will be returned
  Parameters:
  G        - Graph
  Vertex   - The vertex which neighbors have to be searched.
  Vertices - The vertices that are adjacent and can be used.
  Min/Max  - Either the minimum or the maximum
  Costs/Weights - Depending either on costs or weights. 
*/
Graph::getBestAdjacentEdge := proc(G : Graph, Vertex : DOM_LIST, Vertices : DOM_LIST)
local _adjacent, searchWay, searchWith, _vertex, best, i, _edgeNumbers, retVertex;
begin

  // Store the vertices Vertex can reach.
  _adjacent := Graph::getAdjacentEdgesLeaving(G, Vertex);
  searchWay := hold(Min);
  searchWith := hold(Weight);
  best := FAIL;
  retVertex := FAIL;

  if nops(Vertices) = 0 then
    return (best);
  end_if;

  for i from 4 to args(0) do
    case args(i)
      of hold(Min) do        
        break;
      of hold(Max) do
        searchWay := hold(Max);
        break;
      of hold(Costs) do
        searchWith := hold(Costs);
        break;
      of hold(Weights) do        
        break;
      otherwise
        error("Wrong argument definition!");
    end_case;
  end_for;  

  Vertex := op(Vertex);

  if (searchWith = hold(Weight)) then
    _edgeNumbers := Graph::getEdgeWeights(G);
  else
    _edgeNumbers := Graph::getEdgeCosts(G);
  end_if;

  for _vertex in _adjacent do
    if (searchWay = hold(Min)) then
      if (contains(Vertices, _vertex) > 0) then
        if not best = FAIL then
          if (best > _edgeNumbers[[Vertex, _vertex]]) then
            best := _edgeNumbers[[Vertex, _vertex]];
            retVertex := _vertex;
          end_if;           
        else
          best := _edgeNumbers[[Vertex, _vertex]];
          retVertex := _vertex;
        end_if;
      end_if;
    else
      if (contains(Vertices, _vertex) > 0) then
        if not best = FAIL then
          if (best < _edgeNumbers[[Vertex, _vertex]]) then
            best := _edgeNumbers[[Vertex, _vertex]];
            retVertex := _vertex;
          end_if;           
        else
          best := _edgeNumbers[[Vertex, _vertex]];
          retVertex := _vertex;
        end_if;
      end_if;
    end_if;
  end_for;
  
  retVertex;  
end_proc:

// End of file
null():
