/*--
 minCost - minimal cost flow
 minCost(G)
 Parameters:
   G - Graph
 Uses Graph::relaxation
--*/
Graph::minCost := proc(G : Graph)
local flow, i, _edges, _edgeCosts, costTable; 
begin
   if args(0) > 1 then
      error("Wrong number of parameters!");
   end_if;
   _edges := Graph::getEdges(G);
   _edgeCosts := Graph::getEdgeCosts(G);

  // If no "Capacities" are predefined, 0 will be used.
  if _edgeCosts = FAIL then
    for i in _edges do
      _edgeCosts[i] := 0;
    end_for;
  elif nops(_edgeCosts) < nops(_edges) then
    for i in _edges do
      if not contains(_edgeCosts, i) then
        _edgeCosts[i] := 0;
      end_if;
    end_for;
  end_if;

  flow := Graph::relaxation(G);
  costTable := table(_edges[i] = _edgeCosts[_edges[i]] * flow[1][_edges[i]] $ i=1..nops(_edges));
  flow[1], costTable, _plus(_edgeCosts[_edges[i]] * flow[1][_edges[i]] $ i=1..nops(_edges)), flow[2];
end_proc:

// End of file
null():
