/*-
 relaxation - Relaxation Algorithm for solving minimal cost flow problem
    D.P. Bertsekas: 
    Linear Graph Optimization, 
    MIT Press, Cambridge(Mass.)-London,1991
-*/
Graph::relaxation := proc(G : Graph)
local e,i,flow,price,deficit,DD,a,f, has_out_capacity, update_dd, flow_augmentation, price_change, relax_step,
      _vertices, _edges, _vertexWeights, _edgeCosts, _edgeWeights, _edgesLeaving, _edgesEntering;

begin
  _vertices := Graph::getVertices(G);
  _edges := Graph::getEdges(G);
  _vertexWeights := Graph::getVertexWeights(G);
  _edgeCosts := Graph::getEdgeCosts(G);
  _edgeWeights := Graph::getEdgeWeights(G);
  _edgesLeaving := Graph::getEdgesLeaving(G);
  _edgesEntering := Graph::getEdgesEntering(G);
  flow := table();

  if _vertexWeights = FAIL then
    for i in _vertices do
      _vertexWeights[i] := 0;
    end_for;
  end_if;
  assert(nops(_vertexWeights) = nops(_vertices));

  if _edgeWeights = FAIL then
    for i in _edges do
      _edgeWeights[i] := 0;
    end_for;
  end_if;
  assert(nops(_edgeWeights) = nops(_edges));

  // Set to 1 because of predefinition
  if _edgeCosts = FAIL then
    for i in _edges do
      _edgeCosts[i] := 1;
    end_for;
  end_if;
  assert(nops( _edgeCosts) = nops(_edges));

    /*- update_dd - computation of directional derivative  -*/
    update_dd := proc(S,_edgesLeaving,_edgesEntering,_edgeCosts,_edgeWeights,flow,price,deficit)
    local summe, j,e, v, pp;
    begin
      summe := _plus((deficit[op(S,j)] $ j=1..nops(S)));
      for v in S do
        for j in _edgesLeaving[v] do 
          e := [v,j];
          pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
          if pp = 0 then
            if not contains(S,j) then
              summe := summe - (_edgeWeights[e] - flow[e])
            end_if
          end_if
        end_for;
        for j in _edgesEntering[v] do 
          e := [j,v];
          pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
          if pp = 0 then
            if not contains(S,j) then
              summe := summe - flow[e]; //- (flow[e] - low[e]) -
            end_if
          end_if
        end_for;
      end_for;
      summe;
    end_proc:

    /*-
     flow_augmentation - increases flow along an augmenting path from i to j 
    -*/
    flow_augmentation := proc(label,i,j,defic,flo,_edgeWeights)
    local Pp, Pm, oplist, l,w,d,v,deficit,flow;
    // global label (local variable from relax_step) 
    // removed 
    begin
      deficit:=defic; flow:=flo; // to avoid warnings 
      Pp := {}; Pm := {};
      oplist := [deficit[i], -deficit[j]];
      w := j;
      while TRUE do
        l := label[w];
        if w = l[1] then
          // R"uckw"artskante, Fluss wird reduziert 
          Pm := Pm union {l};
          oplist := oplist.[flow[l]];  //- flow[l] - low[l] -
          v := l[2];
        else
          // Vorw"artskante, Fluss wird erh"oht 
          Pp := Pp union {l};
          oplist := oplist.[_edgeWeights[l] - flow[l]];
          v := l[1];
        end_if;
        if v = i then
          break
        end_if;
        w := v;
      end_while;

      if nops(oplist) > 0 then
        d := min(op(oplist));
      else
        d := 0;
      end_if;

      userinfo(2, d,Pp,Pm);

      for e in Pp do
        flow[e] := flow[e] + d;
        deficit[e[1]] := deficit[e[1]] - d;
        deficit[e[2]] := deficit[e[2]] + d
      end_for;

      for e in Pm do
        flow[e] := flow[e] - d;
        deficit[e[1]] := deficit[e[1]] + d;
        deficit[e[2]] := deficit[e[2]] - d
      end_for;
      flow,deficit;
    end_proc:

    /*++ price_change - price adaption  ++*/
    price_change := proc(S,_edgesLeaving,_edgesEntering,_edgeCosts,_edgeWeights,pric,defic,flo)
    local g,i,e,oplist,pp,j, deficit, flow, price;
    begin
      deficit:=defic; flow:=flo; price:=pric; // to avoid warnings 
      oplist := [];
      for i in S do 
        for j in _edgesLeaving[i] do
          e := [i,j];
          if not contains(S,j) then
            pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
            if pp = 0 then
              deficit[e[1]] := deficit[e[1]] + flow[e];
              deficit[e[2]] := deficit[e[2]] - flow[e];
              flow[e] := _edgeWeights[e];
              deficit[e[1]] := deficit[e[1]] - flow[e];
              deficit[e[2]] := deficit[e[2]] + flow[e];
            elif flow[e] < _edgeWeights[e] then
              oplist := oplist.[price[j] + _edgeCosts[e] - price[i]]
            end_if;
          end_if;
        end_for;
        for j in _edgesEntering[i] do
          e := [j,i];
          if not contains(S,j) then
            pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
            if pp = 0 then
              deficit[e[1]] := deficit[e[1]] + flow[e];
              deficit[e[2]] := deficit[e[2]] - flow[e];
              flow[e] := 0; //- := low[e] -
              deficit[e[1]] := deficit[e[1]] - flow[e];
              deficit[e[2]] := deficit[e[2]] + flow[e];
            elif 0 < flow[e] then //- low[e] < flow[e] -
              oplist := oplist.[price[j] - _edgeCosts[e] - price[i]]
            end_if;
           end_if;
        end_for;
      end_for;

      if nops(oplist) > 0 then
        g := min(op(oplist));
      else
        g := 0;
      end_if;

      for i in S do 
        price[i] := price[i] + g;
      end_for;
      flow,deficit,price;
    end_proc:

    /* relax step */
    relax_step := proc(v,_edges,_edgeWeights,_edgeCosts,_edgesLeaving,_edgesEntering,flo,defic,pric,DDD)
    local e,i,L,S,Lh,j,pp,label, price,deficit, flow, DD;
    begin
      L := {v}; S := {};
      DD:=DDD;
      price:=pric; deficit:=defic; flow:=flo; // to avoid warnings 
      while TRUE do
        if S = L then
          price_change(S,_edgesLeaving,_edgesEntering,_edgeCosts,_edgeWeights,price,deficit,flow);
          flow := %[1];
          deficit := %2[2];
          price := %3[3];
          return(flow,deficit,price,DD);
        else
          i := op(L minus S, 1);
          S := S union {i};
          DD := update_dd(S,_edgesLeaving,_edgesEntering,_edgeCosts,_edgeWeights,flow,price,deficit);
        end_if;
        if DD > 0 then 
          price_change(S,_edgesLeaving,_edgesEntering,_edgeCosts,_edgeWeights,price,deficit,flow);
          flow := %[1];
          deficit := %2[2];
          price := %3[3];
          return(flow,deficit,price,DD);
        else
          Lh := {};
          for j in _edgesLeaving[i] do
            if not contains(L,j) then
              e := [i,j];
              pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
              if pp = 0 and flow[e] < _edgeWeights[e] then
                Lh := Lh union {j};
                label[j] := e;
              end_if;
            end_if;
          end_for;
          for j in _edgesEntering[i] do
            if not contains(L,j) then
              e := [j,i];
              pp := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
              if pp = 0 and 0 < flow[e] then //- low_capacity[e] < flow[e] -
                Lh := Lh union {j};
                label[j] := e;
              end_if;
            end_if;
          end_for;
          L := L union Lh;
          for j in Lh do
            if deficit[j] < 0 then
              flow_augmentation(label,v,j,deficit,flow,_edgeWeights);
              flow := %[1];
              deficit := %2[2];
              return(flow,deficit,price,DD);
            end_if;
          end_for;
        end_if;
      end_while;
    end_proc:

   /*- Initialisation of 
        flow - Graph flow
        price - local prices
        deficit - supply/demand of nodes
        DD directional derivative
   -*/
   price := table(_vertices[i] = 0 $ i=1..nops(_vertices));
   deficit := table(_vertices[i] = _vertexWeights[_vertices[i]] $ i=1..nops(_vertices));
   for e in _edges do 
     i := price[e[1]] - (_edgeCosts[e] + price[e[2]]);
     if i <= 0 then
       flow[e] := 0;  //- lower_capacity[e] -
       deficit[e[1]] := deficit[e[1]] - flow[e];
       deficit[e[2]] := deficit[e[2]] + flow[e];
     else
       flow[e] := _edgeWeights[e];
       deficit[e[1]] := deficit[e[1]] - flow[e];
       deficit[e[2]] := deficit[e[2]] + flow[e];
     end_if;
   end_for;
   DD := 0;
   f := v -> bool(deficit[v] > 0);

   /* has_out_capacity */
   has_out_capacity := proc(v)
   local other, edge;
   begin
     for other in _edgesLeaving[v] do
       edge := [v, other];
       if not contains(flow, edge)
         or flow[edge] < _edgeWeights[edge] then
         return(TRUE);
       end_if
     end_for;
     return(FALSE);
   end_proc;
   
   repeat
     a := select(_vertices, f);
     a := select(a, has_out_capacity);
     if nops(a) = 0 then
      break; //- Termination: there are no more deficit nodes -
     end_if;
     a := relax_step(a[1],_edges,_edgeWeights,_edgeCosts,_edgesLeaving,_edgesEntering,flow,deficit,price,DD);
     flow := a[1];
     deficit := a[2];
     price := a[3];
     userinfo(1,"price=",price);
     DD := a[4];
   until FALSE end_repeat;
   
   flow,price;
end_proc:

// End of file
null():
