/*- 
 removeEdge - removes one or several edges from a Graph
 removeEdge(G, Edge)
 removeEdge(G, [e1..en] <,OnlySpecifiedEdges>)
 Parameters:
   G    - Graph
   Edge - a list of one or more edges
-*/
Graph::removeEdge := proc(G : Graph, Edge : Type::ListOf(DOM_LIST))
local _edges, _correctEdges, _edgeWeights, _edgeDescriptions, _edgeCosts, _edgesEntering, _edgesLeaving, 
      x, position, operands, tmpList, _onlySE;
begin
   _onlySE := FALSE;
   if args(0) = 3 then
     if op(args(3)) = hold(OnlySpecifiedEdges) then
       _onlySE := TRUE;
     end_if;
   end_if;
   // Get the already existing vertices
   _correctEdges := Graph::selectEdge(G, Edge, TRUE, Show=FALSE, OnlySpecifiedEdges=_onlySE);

   // If graph is undirected put also reverted edges to it.
   if Graph::isDirected(G) = FALSE and not _onlySE then
     tmpList := _correctEdges;
     for x in tmpList do
       if contains(_correctEdges, revert(x)) = 0 then
         _correctEdges := append(_correctEdges, revert(x));      	
       end_if;
     end_for;      
   end_if;

   _edges := Graph::getEdges(G);
   _edgeWeights := Graph::getEdgeWeights(G);
   _edgeDescriptions := Graph::getEdgeDescriptions(G);
   _edgeCosts := Graph::getEdgeCosts(G);
   _edgesEntering := Graph::getEdgesEntering(G);
   _edgesLeaving := Graph::getEdgesLeaving(G);

   // Check was already done and only not existing edges remain !
   // Also no check for Directed must be done, because if it is directed pair-edges will always be returned.
   for x in _correctEdges do
     position := contains(_edges,x);
     if position > 0 then
       delete _edges[position];
     end_if;

     if _edgeWeights <> FAIL then
       delete _edgeWeights[x];
       if nops(_edgeWeights) = 0 then
         _edgeWeights := FAIL;
       end_if;                  
     end_if;

     if _edgeDescriptions <> FAIL then
       delete _edgeDescriptions[x];
       if nops(_edgeDescriptions) = 0 then
         _edgeDescriptions := FAIL;
       end_if;  
     end_if;

     if _edgeCosts <> FAIL then
       delete _edgeCosts[x];
       if nops(_edgeCosts) = 0 then
         _edgeCosts := FAIL;
       end_if;  
     end_if;

     if _edgesEntering <> FAIL then
       operands := _edgesEntering[x[2]];
       position := contains(operands, x[1]);
       delete operands[position];          
       _edgesEntering[x[2]] := sort(operands);
     end_if;

     if _edgesLeaving <> FAIL then
       operands := _edgesLeaving[x[1]];
       position := contains(operands, x[2]);
       delete operands[position];          
       _edgesLeaving[x[1]] := sort(operands);
     end_if;
   end_for;

   subsop(G, 2=_edges, 4=_edgeDescriptions, 5=_edgeWeights, 6=_edgeCosts, 7=_edgesEntering, 8=_edgesLeaving);
end_proc:

// End of file
null():

