/*-
 selectEdge - checks if one ore more edges are already defined in a graph and returns a new table with edges
             that are not in the graph yet or that already are defined depending on "existing".
             If the optional parameter show is set to false, already defined edges will not be printed.
 selectEdge(G, Edge, existing)
 selectEdge(G, Edge, existing <,Show = TRUE/FALSE> <,OnlySpecifiedEdges=TRUE|FALSE>)
 selectEdge(G, [e1,..,en], existing)
 selectEdge(G, [e1,..,en], existing <,Show = TRUE/FALSE> <,OnlySpecifiedEdges=TRUE|FALSE>)
 Parameters:
   G    - Graph
   Edge - a list of one or more edges
   existing - TRUE returns all edges that already exist in the graph.
              FALSE returns all edges that are not in the graph.
   Show     - TRUE (standard) show if any vertices were found not matching the criteria.
              FALSE supress the output.

-*/
Graph::selectEdge := proc(G, Edge : Type::ListOf(DOM_LIST), existing : DOM_BOOL)
local _currentEdges, _existingEdges, _newEdges, dummy, leftOperator, rightOperator,_show,_onlySE, i; 
begin
  _show := TRUE; // predefinition
  _onlySE := FALSE;

  if args(0) > 3 then
    for i from 4 to args(0) do
      if not (type(args(i)) = "_equal") then
        error("Wrong argument '".expr2text(args(i))."': equation expected!");      
      end_if;     
      leftOperator := op(args(i),1); 
      rightOperator := op(args(i),2);
      case leftOperator
        of hold(Show) do
          if not testtype(rightOperator, DOM_BOOL) then
            error("Wrong value for option '".expr2text(args(i))."': TRUE or FALSE expected!");
          end_if;
          _show := rightOperator;
          break;
        of hold(OnlySpecifiedEdges) do
          if not testtype(rightOperator, DOM_BOOL) then
            error("Wrong value for option '".expr2text(args(i))."': TRUE or FALSE expected!");
          end_if;
          _onlySE := rightOperator;
          break;
        otherwise
          error("Wrong argument: '".expr2text(args(i))."'!");      
      end_case;
    end_for;
  end_if;

  _currentEdges := Graph::getEdges(G);

  if existing = TRUE then
    if Graph::isDirected(G) or _onlySE then
      [_newEdges, _existingEdges, dummy] := split(_currentEdges, _edge -> contains(Edge, _edge) > 0);
    else
      [_newEdges, _existingEdges, dummy] := split(_currentEdges, (_edge -> contains(Edge, _edge) > 0)
                                                  or (_edge -> contains(Edge, revert(_edge)) > 0));
    end_if;
  else
    if Graph::isDirected(G) or _onlySE then
      [_existingEdges, _newEdges, dummy] := split(Edge, _edge -> contains(_currentEdges, _edge) > 0);
    else
      [_existingEdges, _newEdges, dummy] := split(Edge, (_edge -> contains(_currentEdges, _edge) > 0)
                                                  or (_edge -> contains(_currentEdges, revert(_edge)) > 0));
    end_if;
  end_if;

  if _show = TRUE then
    if _existingEdges <> [] then
      warning("The following edges were not used for operation: " . expr2text(_existingEdges) . "\n");
    end_if;
  end_if;

  return(_newEdges);
end_proc:

// End of file
null():

