/*-
 selectVertex - checks if one ore more Vertices are already defined in a graph and returns a new list with vertices
               that are either not in the graph so far or that already are defined depending on "existing".
               If the optional parameter Show is set to false, already defined vertices will not be printed.
 selectVertex(G, Vertex, existing)
 selectVertex(G, Vertex, existing <,Show = TRUE/FALSE>)
 selectVertex(G, [e1,..,en], existing)
 selectVertex(G, [e1,..,en], existing <,Show = TRUE/FALSE>)
 Parameters:
   G        - Graph
   Vertex   - a list of one or more vertices
   existing - TRUE returns all vertices that already exist in the graph.
              FALSE returns all vertices that are not in the graph.
   Show     - TRUE (standard) show if any vertices were found not matching the criteria.
              FALSE supress the output.
-*/
Graph::selectVertex := proc(G : Graph, Vertex : DOM_LIST, existing : DOM_BOOL)
local _currentVertices, _existingVertices, _newVertices, dummy, leftOperator, rightOperator, _show; 
begin
  _show := TRUE; // predefinition

  if args(0) = 4 then
    if not (type(args(4)) = "_equal") then
      error("Wrong argument type: equation expected!");
    end_if;
    leftOperator := op(args(4),1); 
    rightOperator := op(args(4),2);
    case leftOperator
      of hold(Show) do
        _show := rightOperator;
        break;
      otherwise
        error("Wrong type of ".expr2text(args(4))." argument: Show expected!");
    end_case;
  end_if;

  _currentVertices := Graph::getVertices(G);

  if existing = TRUE then
    [_newVertices, _existingVertices,dummy] := split(_currentVertices, _edge -> contains(Vertex, _edge) > 0);
  else
    [_existingVertices, _newVertices,dummy] := split(Vertex, _edge -> contains(_currentVertices, _edge) > 0);
  end_if;

  if _show = TRUE then
    if _existingVertices <> [] then
      warning("The following vertices already exist: " . expr2text(_existingVertices) . "\n");
    end_if;
  end_if;

  return(_newVertices);

end_proc:

// End of file
null():

