/*-
 setEdgeWeights - changes the weight of one ore more edges of a Graph
 setEdgeWeights(G, Edge, EdgeWeights <,OnlySpecifiedEdges>)
 setEdgeWeights(G, [e1,..,en], [c1,..,cn] <,OnlySpecifiedEdges>)
 Parameters:
   G            - Graph
   Edge         - a list of lists of one or more edges
   EdgeWeights  - a list of one or more edge weights
-*/
Graph::setEdgeWeights := proc(G : Graph, Edge : Type::ListOf(DOM_LIST), EdgeWeights : Type::Union(DOM_LIST, DOM_TABLE))
local _edges, _existingEdges, _edgeWeights, position, x, _onlySE, reverted;
begin
    if args(0) > 4 then
      error("Wrong number of arguments! See help for more details.");
    end_if;

  _onlySE := FALSE;
  if args(0) = 4 then
     if op(args(4)) = hold(OnlySpecifiedEdges) then
       _onlySE := TRUE;
     end_if;
  end_if;  

  _edges := Graph::getEdges(G);
  _edgeWeights := Graph::getEdgeWeights(G);
  _existingEdges := Graph::selectEdge(G, Edge, TRUE, Show=FALSE, OnlySpecifiedEdges=_onlySE);

  if _existingEdges = [] then
    warning("No edge weight to be changed.");
  else
    if domtype(EdgeWeights) = DOM_TABLE then
      for x in _existingEdges do
        reverted := FALSE;
        if contains(EdgeWeights, x) = FALSE then // check the reverted edge if original edge does not exist!
          x := [op(x,2),op(x,1)];
          reverted := TRUE;
        end_if;
        if EdgeWeights[x] = hold(None) then
          // remove edge from list, because it is not necessary.
          if reverted then
            x := [op(x,2),op(x,1)];
            if _edgeWeights <> FAIL and contains(_edgeWeights, x) then
               delete _edgeWeights[x];
            end_if;
          else  
            if _edgeWeights <> FAIL and contains(_edgeWeights, x) then
               delete _edgeWeights[x];
            end_if;
          end_if;
        else
          if reverted then
            if contains(EdgeWeights, x) then
              _edgeWeights[[op(x,2),op(x,1)]] := EdgeWeights[x];
            end_if;
          else  
            if contains(EdgeWeights, x) then
              _edgeWeights[x] := EdgeWeights[x];
            end_if;
          end_if;
        end_if;
      end_for;
    else
      for x in _existingEdges do
        reverted := FALSE;
        position := contains(Edge, x);

        if position = 0 then
          x := [op(x,2),op(x,1)];
 	        position := contains(Edge, x);
          reverted := TRUE;
        end_if;
        // just overwrite the predefined weight or create a new one if not defined before.
        if EdgeWeights[position] = hold(None) then
          // remove edge out of list, because it is not necessary.
          if reverted then
            if _edgeWeights <> FAIL and contains(_edgeWeights, [op(x,2),op(x,1)]) then
               delete _edgeWeights[[op(x,2),op(x,1)]];
            end_if;
          else  
            if _edgeWeights <> FAIL and contains(_edgeWeights, x) then
               delete _edgeWeights[x];
            end_if;
          end_if;
        else
          if reverted then
            if position > 0 then
              _edgeWeights[[op(x,2),op(x,1)]] := EdgeWeights[position];            	
            end_if;
          else  
            if position > 0 then
              _edgeWeights[x] := EdgeWeights[position];            	
            end_if;
          end_if;
        end_if;
      end_for;
    end_if;
  end_if;

  subsop(G, 5=_edgeWeights);
end_proc:

// End of file
null():

