// 
/*
  Graph::_union -- still underspecified, therefore undocumented.

   To do: Specify what should happen with multiple weightsand costs. Error?
          Check that the code below works properly for mixtures of
            directed and undirected graphs.
*/

Graph::_union :=
proc(G1, G2)
  local vertices, edges, vertexWeights, edgeDescriptions, edgeWeights,
	edgeCosts, directed, G, tableop;
begin
  if args(0) = 1 then
    return(G1);
  end_if;
  
  if G1::dom <> dom or G2::dom <> dom then
    return(FAIL);
  end_if;

  if args(0) > 2 then
    G2 := _union(args(2..args(0)));
  end_if;
  
  // workaround for the design decision to return FAIL for undefined edge costs etc.
  tableop := x-> op(x);
  tableop(FAIL) := null():
  
  directed := dom::isDirected(G1) or dom::isDirected(G2);
  vertices := listlib::removeDuplicates(dom::getVertices(G1).
					dom::getVertices(G2));

  edges := listlib::removeDuplicates(dom::getEdges(G1).
				     dom::getEdges(G2));
  edgeCosts := table(tableop(dom::getEdgeCosts(G1)),
		     tableop(dom::getEdgeCosts(G2)));
  vertexWeights := table(tableop(dom::getVertexWeights(G1)),
			 tableop(dom::getVertexWeights(G2)));
  edgeDescriptions := table(tableop(dom::getEdgeDescriptions(G1)),
			    tableop(dom::getEdgeDescriptions(G2)));
  edgeWeights := table(tableop(dom::getEdgeWeights(G1)),
		       tableop(dom::getEdgeWeights(G2)));

  if directed then
    G := dom::new(vertices, edges, Directed);
  else
    // workaround for "error: Duplicate edges were given"
    edges := listlib::removeDuplicates(map(edges, sort));
    G := dom::new(vertices, edges);
  end_if;

  // workaround for warnings: check firt if something has to be changed
  if nops(edgeCosts) > 0 then
    G := Graph::setEdgeCosts(G, map([op(edgeCosts)], lhs),
			     edgeCosts);
  end_if;
  
  if nops(edgeDescriptions) > 0 then
    G := Graph::setEdgeDescriptions(G, map([op(edgeDescriptions)], lhs),
				    edgeDescriptions);
  end_if;
  
  if nops(edgeWeights) > 0 then
    G := Graph::setEdgeWeights(G, map([op(edgeWeights)], lhs),
			       edgeWeights);
  end_if;
  
  if nops(vertexWeights) > 0 then
    G := Graph::setVertexWeights(G, map([op(vertexWeights)], lhs),
				 vertexWeights);
  end_if;
  
  return(G);
end_proc:
