/* groebner::dimension(g) computes the dimension of the affine variety
  generated by the polynomials in g.

Reference: Ideals, Varieties and Algorithms, by Cox, Little, O'Shea, 
	Springer-Verlag, 1992, Chapter 9.

Example:
from Cox, Little, O'Shea pages 411-412
>> groebner::dimension({x2^2*x3^3,x1^5*x3^4,x1^2*x2*x3^2});

                                     2

from Cox, Little, O'Shea Ex. 6d page 436
>> groebner::dimension({x^3-y*z^2,y^4-x^2*y*z});

                                     1

>> groebner::dimension({x^3+y+z,x+y^3+z,x+y+z^3});

                                     0

*/
groebner::dimension :=
proc(g,o=null())
  local m,j,M,t,n,x,k,MM,i,J;
begin
   if args(0) = 1 then
     o:=hold(DegInvLexOrder)
   elif args(0) <> 2 then
     error("wrong no of arguments") 
   end_if;
  if domtype(g)=DOM_SET then
    g:=[op(g)]
  end_if;
  if domtype(g)<>DOM_LIST then
    error("illegal argument")
  end_if;
  if type(g[1])<>DOM_POLY then
    if contains(map({op(g)}, domtype), DOM_POLY) then
       error("Input must consist only of polynomials or only of expressions")
    end_if;
    g:=map(g,poly,[op(indets(g))]);
    if contains(g,FAIL) <> 0 then 
      error("illegal argument") 
    end_if;
  else
    if map({op(g)}, domtype) <> {DOM_POLY} then
      error("Input must consist only of polynomials or only of expressions")
    end_if
  end_if;
  g:=groebner::gbasis(g, o);
  x:={op(op(g[1],2))}; n:=nops(x);
  if nops(g)=1 then
    if iszero(expr(g[1])) then
     // variety is the full space
     return(n)
    end_if;
    if expr(g[1]) = 1 then
      return(-1)
    end_if;
  end_if;
  m:=map(g,expr@lterm,o);
  t:=nops(m);
  MM:={}; M:=[];
  for j from 1 to t do
     indets(m[j]);
      // if only one variable, it must appear in the coordinate subspace 
     if nops(%)=1 then
        MM:=MM union %;
             x:=x minus %
      else
        M:=append(M,%)
      end_if;
   end_for;
  MM:=(if MM={} then map(x,DOM_SET) else {MM} end_if);
  for i from degree(op(MM,[1,1])) to n-1 do
     for J in MM do
        if _and((_intersect(J,M[j])<>{})$j=1..nops(M)) then
           return(n-nops(J))
         end_if
      end_for;
     MM:=_union(map(MM,_union,{op(x,k)})$k=1..nops(x)) minus MM;
   end_for;
  0
end_proc:
