/* eliminate vars among a set of polynomials or polynomial equations 
	usage: eliminate(eqs,vars) 
  	args:
         eqs : a list or set of equation or of polynomial expressions
   		vars: a list of variables 
	returns: a list of polynomial expressions 
	example:
	eliminate([x+y+z+t-2,x*y*t=1,x^2+t^2=z^2],[x,z]);
	implementation: straight forward standard algorithm using a lexical groebner basis
*/

groebner::eliminate:=
proc(eqs: Type::Union(DOM_SET, DOM_LIST), elimvars)
  local pols, gb, vars, vr,gbl;
begin
  if args(0)<>2 then
    error("wrong number of arguments")
  end_if;

  if domtype(eqs)=DOM_SET then
    eqs:=[op(eqs)]
  end_if;
  
  eqs:=map(eqs, e -> if type(e)="_equal" then
                       op(e,1)-op(e,2)
                     else
                       e
                     end_if); 

  vars:= indets(eqs) minus Type::ConstantIdents;
  vr:= [op(vars minus {op(elimvars)})];
  vars:= [op(elimvars),op(vr)];
  pols:= map(eqs,poly, vars);
  gb:= groebner::gbasis(pols, LexOrder);
  gbl:= map(gb, op, 1); 
  select(gbl, p-> not has(p, elimvars))
end_proc:



