// groebner::getoptions

// return a table of options

// if a table is given as first argument, return this table
// if no argument is given, return the default options
// if some arguments are given, return these as options



groebner::getoptions:=
proc()
local
  options: DOM_TABLE,
  i: DOM_INT;
  
begin
  if args(0)>=1 and type(args(1)) = DOM_TABLE then
    return(args(1))
  end_if;
  
  options:= groebner::defaultOptions;

  for i from 1 to args(0) do
     case type(args(i))
       of DOM_IDENT do
         case args(i)
           of hold(Reorder) do
             options["Reorder"]:=TRUE;
             break
           of hold(LexOrder) do
           of hold(DegInvLexOrder) do
           of hold(DegreeOrder) do
             options["Order"]:= args(i);
             break
           otherwise
             error("Unknown option ".expr2text(args(i)))
         end_case;
         break
       of Dom::MonomOrdering do
         options["Order"]:= args(i);
         break
       of "_equal" do
         case op(args(i),1)
           of hold(Monic) do
             options["Monic"]:=op(args(i), 2);
             break
           of hold(Order) do
             options["Order"]:=op(args(i), 2);
             break
           otherwise
             error("Unknown option ".expr2text(args(i)))
         end_case;
         break
       otherwise
         error("Unknown option ".expr2text(args(i)))
     end_case
   end_for;

  userinfo(100, "Options used: ".expr2text(options));
   
  options

end_proc:


groebner::defaultOptions:=
table(
      "Reorder" = FALSE,
      "Monic" = hold(Default),
      "Order" = hold(DegInvLexOrder)
      ):
           

