/*--
opt_order -- find heuristically optimal variable ordering

opt_order(S)

S - list of polynomials

opt_order returns a re-arranged list of variables of the polynomials in S
where the ordering of the variables is "heuristically optimal" in the
sense of Boege et al. (See W. Boege, R.Gebauer, H.Kredel:"Some Examples
for Solving Equations by Calculating Groebner Bases", J. Symbolic Comp.
(1986) Vol 1, 83-98.)
--*/

groebner::opt_order:= proc(S)
    local n, i, j, k, X, P, OO, T;
begin
    X:= op(S[1], 2);
    n:= nops(X);
    if n=1 then return(X) end_if; // otherwise evalp produces an error below 
    T:= op(S[1], 3);

    if T = hold(Expr) then
        S:= map(S, mapcoeffs, 1);
    elif domtype(T) = DOM_DOMAIN then
        S:= map(map(S, mapcoeffs, T::one), poly, hold(Expr));
    else
    	S:= map(map(S, mapcoeffs, 1), poly, hold(Expr));
    end_if;
    OO:= nops(S);
    P:= [ subs(_plus(evalp(S[k], X[j]=1 $ j=1..i-1, X[j]=1 $ j=i+1..n)
	    $ k=1..OO), X[i]=X[1]) $ i=1..n ];

    OO:= sort([i $ i=1..n], (()->(lcoeff(P[args(2)]-P[args(1)]) > 0)));

    [ X[OO[i]] $ i=1..n ]
end_proc:

// end of file 
