/*--
redset_insert -- insert polynomial/leading term into reducing set

redset_insert(S, p)

S - reducing set
p - polynomial/leading term pair

The reducing set is a list of lists [l1,...,ln]. Each sublist li contains
those polynomial/leading term pairs with total degree i of the leading term.
--*/

groebner::redset_insert:=
  proc(S, p)
    local i, deg;
  begin
    deg := degree(p[2]);
    if deg > nops(S) then
      append(S, [] $ i=(nops(S)+1)..(deg-1), [p])
    else
      subsop(S, deg=append(S[deg], p))
    end_if
  end_proc:

// end of file 
