/*--
reduce -- fully reduces sugared polynomial p modulo polynomials in set S

reduce(p, S)

p   - sugared polynomial
S   - reducing set (base of ideal)
o   - order 

This is algorithm 10.1 (Reduce) of Geddes et al (p436). It is _the_
time critical operation of the basis computation.

The reducing set is a list of lists [l1,...,ln]. Each sublist li contains
those sugared polynomials with total degree i of the leading term.
--*/

groebner::reduce:=
proc(p, S, o, gplus)
//  local d, lp, q, n, i, e, s;
  local lp, q, s;
begin
  lp:= p[2]; s:= p[3]; p:= p[1];

/*
  q:=p^0-p^0;
  n:= nops(S);
  while not iszero(p) do
    // find reducing polynomial e in S
    d:= FAIL;
    for i from min(degree(lp), n) downto 1 do
      for e in S[i] do
        d:= divide(lp, e[2], Exact);
        if d <> FAIL then
          e:= e[1];
          break
        end_if
      end_for;
      if d <> FAIL then break end_if
    end_for;
    
    if d = FAIL then
      // remove irreducible monomial
      lp:= lmonomial(p,o,Rem);
      p:= lp[2];
      lp:= lp[1];
      q:= q + lp;
    else
      // reduce p via e
      p:= gplus(p, e * multcoeffs(d, - lcoeff(p,o)/
                                  lcoeff(e,o)));
    end_if;
    lp:= lterm(p,o);
  end_while;
*/
  q := divide(p, op(map(map(revert(S), op), op, 1)), o, Rem);
  [q, lterm(q,o), s]
end_proc:

// end of file 
