/*++
spoly -- returns S-polynomial of p and q
 
spoly(p, q [,o])
 
p,q - polynomials
o   - optional term ordering (LexOrder, DegInvLexOrder or DegreeOrder,
	or function)

'DegInvLexOrder' is used if no order is given.
++*/
 
groebner::spoly:=
proc(p, q, o)
  local conv, s, gplus;
begin
  if args(0) = 2 then
    o:= hold(DegInvLexOrder)
  end_if;
  gplus:=_plus;
  if testargs() then
    if args(0) <> 3 and args(0) <> 2 then
      error("wrong no of args")
    end_if;
    if not contains({hold(DegreeOrder), hold(LexOrder),
                     hold(DegInvLexOrder)}, o) and type(o)=DOM_IDENT then
      error("unknown order")
    end_if
  end_if;

  if domtype(p) = DOM_POLY then
    conv:= id
  elif p::dom::poly <> FAIL then
    conv:= p::dom::new;
    p:= p::dom::poly(p);
    q:= p::dom::poly(q)
  else
    p:= gcdlib::expr2polys([p, q], Type::Rational);
    if p = FAIL then
      error("not a rational polynomial")
    end_if;
    q:= p[2];
    p:= p[1];
    conv:= expr
  end_if;

  if testargs() then
    groebner::test_poly(p);
    groebner::test_poly(q);
    if op(p, 2..3) <> op(q, 2..3) then
      error("polynomial types don't match")
    end_if;
    if domtype(op(p,3)) = DOM_DOMAIN then
      groebner::test_domain(op(p,3))
    end_if;
  end_if;

  
  p:= [p, lterm(p, o), 0];
  q:= [q, lterm(q, o), 0];
  s:= groebner::s_poly([p, q, groebner::term_lcm(p[2], q[2]), 0], o, gplus);
  
  conv(s[1])
end_proc:

// end of file 
