
/*

groebner::stronglyIndependentSets(G)

G - groeber basis of some ideal

returns a list [d, S, M]

where

d: dimension of the ideal I generated by G
S: greatest stronlgy independent set of vars mod I
M: set of maximal strongly independent sets of vars mod I



Source: Kredel/Weispfennig, JSC 6 (1988), 231-247


*/



groebner::stronglyIndependentSets:=
proc(G: DOM_LIST, ord = null())
  local
     dimrec: DOM_PROC,
     d, S, U, M, htG, i,
     ok: DOM_BOOL;
  
begin

// local procedure dimrec


  
  dimrec:=
  proc(S, U, M)
    // uses G from outer proc
    local u, newS;
    
  begin
    while nops(U) > 0 do
      u:=U[1];
      delete U[1];
      newS:= S union {u};
      ok:= TRUE;
      for i from 1 to nops(htG) do
        if indets(htG[i]) minus newS = {} then
          ok:= FALSE;
          break
        end_if;
      end_for;
      if ok then
        M:= dimrec(newS, U, M);
      end_if;
    end_while;
    // test if S is already contained in some element of M
    if contains(map(M, m -> bool(S minus m = {})), TRUE) then
      M
    else
      M union {S}
    end_if
  end_proc;


  // main program
  
  if testargs() then
    if map(G, type) <> [DOM_POLY $nops(G)] then
    	error("List must consist of polynomials")
    end_if 
  end_if;

  htG:= map(G, lterm, ord);
  htG:= map(htG, expr);

  M := {};
  if contains(map(G, degree), 0)>0 then
    return(FAIL)
  end_if;
  S:= {};
  U:= op(G[1], 2);

  M:= dimrec(S, U, M);

  d:= 0;

  for i from 1 to nops(M) do
    if nops(op(M, i)) > d then
      d:= nops(op(M, i));
      S:= op(M, i);
    end_if
  end_for;

  [d, S, M]

end_proc: