/*
>> import::readlisp("(INTEGRATE (EXPT X -1) X)");

                                   / 1    \
                                int| -, X |
                                   \ X    /

>> import::readlisp("(BESSEL-J X 1)");

                               besselJ(1, X)
*/
import::LispBlank:={" ","\n","\t"}:

import::readlisp := proc(s: DOM_STRING) local n, erg;
begin
  erg:= import::parseLisp([s[n]$n=1..length(s)]) ;
  if erg[2] <> [] then
    while erg[2]<>[] and contains(import::LispBlank,erg[2][1])
    do delete erg[2][1] end_while;
    if erg[2] <> [] then
      error("unexpected character ".erg[2][1] )
    end_if ;
  end_if ;
  erg[1] ;
end_proc:

/* import::parseLisp(l) parses a Lisp expression and returns this expression
  together with the remaining stream.
Example:
>> import::parseLisp(["(","E","X","P","T"," ","X"," ","-","1",")"," ","X",")"]);

                         -- 1                  --
                         |  -, [" ", "X", ")"]  |
                         -- X                  --
*/

import::parseLisp:=proc(l)
begin
   while l<>[] and contains(import::LispBlank,l[1]) do delete l[1] end_while;
   if l = [] then return([hold(null()),[]]) ; end_if;
   if l[1]="(" then import::parseLambda(l)
   else import::parseIdent(l)
   end_if
end_proc:

import::parseLambda:=proc(l) local f,Args,g;
begin
   while l<>[] and l[1]<>"(" do delete l[1] end_while;
   delete l[1];
   ([f,l]):=import::parseIdent(l);
   while l<>[] and contains(import::LispBlank,l[1]) do delete l[1] end_while;
   Args:=null();
   while l<>[] do
      while l<>[] and contains(import::LispBlank,l[1]) do delete l[1] end_while;
      if l[1]=")" then delete l[1];
         if domtype(import::lispFun2MuPAD(f))=DOM_PROC then
            g:=import::lispFun2MuPAD(f)
         else g:=f
         end_if;
         return([g(Args),l])
      end_if;
      g:=import::parseLisp(l);
      Args:=Args,g[1];
      l:=g[2];
   end_while;
   error("missing closing parenthesis") ;                       
end_proc:

import::parseIdent:=proc(l) local f;
begin
   f:="";
   while l<>[] and not contains(import::LispBlank union {"(",")"},l[1]) 
   do f:=f.l[1]; delete l[1] end_while;
   if f = "" then
     error("identifier expected")
   end_if ;
   f:=import::Ident2MuPAD(f);
   [f,l]
end_proc:

import::Ident2MuPAD:=proc(s) begin text2expr(s) end_proc:
import::Ident2MuPAD("*"):=hold(_mult):
import::Ident2MuPAD("+"):=hold(_plus):
import::Ident2MuPAD("/"):=hold(_divide):
import::Ident2MuPAD("ARCCOS"):=hold(arccos):
import::Ident2MuPAD("ARCCOSECH"):=hold(arccsch):
import::Ident2MuPAD("ARCCOSH"):=hold(arccosh):
import::Ident2MuPAD("ARCCOT"):=hold(arccot):
import::Ident2MuPAD("ARCCOTH"):=hold(arccoth):
import::Ident2MuPAD("ARCCSC"):=hold(arccsc):
import::Ident2MuPAD("ARCSEC"):=hold(arcsec):
import::Ident2MuPAD("ARCSECH"):=hold(arcsech):
import::Ident2MuPAD("ARCSIN"):=hold(arcsin):
import::Ident2MuPAD("ARCSINH"):=hold(arcsinh):
import::Ident2MuPAD("ARCTAN"):=hold(arctan):
import::Ident2MuPAD("ARCTANH"):=hold(arctanh):
import::Ident2MuPAD("BESSEL-J"):=hold(besselJ):
import::Ident2MuPAD("COS"):=hold(cos):
import::Ident2MuPAD("COSEC"):=hold(csc):
import::Ident2MuPAD("COSECH"):=hold(csch):
import::Ident2MuPAD("COSH"):=hold(cosh):
import::Ident2MuPAD("COT"):=hold(cot):
import::Ident2MuPAD("COTH"):=hold(coth):
import::Ident2MuPAD("CSC"):=hold(csc):
import::Ident2MuPAD("CSCH"):=hold(csch):
import::Ident2MuPAD("ERF"):=hold(erf):
import::Ident2MuPAD("EXP"):=hold(exp):
import::Ident2MuPAD("EXPT"):=hold(_power):
import::Ident2MuPAD("GAMMA"):=hold(gamma):
import::Ident2MuPAD("INF"):=hold(infinity):
import::Ident2MuPAD("LOG"):=hold(ln):
import::Ident2MuPAD("MINF"):=hold(-infinity):
import::Ident2MuPAD("SEC"):=hold(sec):
import::Ident2MuPAD("SECH"):=hold(sech):
import::Ident2MuPAD("SIN"):=hold(sin):
import::Ident2MuPAD("SINH"):=hold(sinh):
import::Ident2MuPAD("SQRT"):=hold(sqrt):
import::Ident2MuPAD("TAN"):=hold(tan):
import::Ident2MuPAD("TANH"):=hold(tanh):

import::lispFun2MuPAD(besselJ):= (x,y) -> besselJ(y,x):

import::lispFun2MuPAD(divide):=  (x,y) -> x/y:

import::lispFun2MuPAD(hold(HYPERGEOMETRIC)):=
proc()
  local Nargs, tmp;
begin 
  Nargs := args(0);
  tmp := contains([args()],hold(OVER));
  hypergeom([args(1..tmp-1)],[args(tmp+1..Nargs-1)],args(Nargs))
end_proc :

import::lispFun2MuPAD(hold(INTEGRATE)):=
proc(x, y)
begin 
  if args(0)=2 then
    hold(int)(x, y)
  else
    hold(int)(x, y = args(3)..args(4))
  end_if
end_proc :

