// 

// besselJ evaluation for intervals

// series for indices not close to a negative integer
// (the series remains valid there, too, but cancellation gets bad)
// and small |z|:

DOM_INTERVAL::besselJ_series1 :=
proc(v, z)
  local m, m0, c0, remainder, zhalfsquared,
	sersum, summand, i;
begin
  // TODO: negative v, intersect v with semiplanes
  c0 := z^v/(2^v*gamma(v+1));
  zhalfsquared := (z/2)^2;
  
  // TODO calculate m0
  m0 := ceil(10*rhs(abs(z/v)))+5;
  
  sersum := 1;
  summand := 1;
  for m from 1 to m0-1 do
    summand := - summand * zhalfsquared / (m*(v+m));
    sersum := sersum + summand;
  end_for;
  
  remainder := abs(zhalfsquared^m0/_mult(v+i$i=1..m0))
	     * abs(exp(abs(zhalfsquared/(v+m0))))/m0!;
  
  if iszero(Im(v)) and iszero(Im(z)) then
    sersum := sersum + (-1...1)*remainder;
  else
    sersum := sersum + (-1-I...1+I)*remainder;
  end_if;
  
  c0*sersum;
end_proc:

// this will become DOM_INTERVAL::besselJ once it runs stable
DOM_INTERVAL::besselJ_to_be :=
proc(v, z)
begin
  v := interval(v);
  z := interval(z);
  if v::dom <> DOM_INTERVAL then
    if v = {} then return(v); end_if;
    return(FAIL);
  end_if;
  if z::dom <> DOM_INTERVAL then
    if z = {} then return(z); end_if;
    return(FAIL);
  end_if;
  
  if op(v, 0) = hold(_union) then
    _union(map(op(v), DOM_INTERVAL::besselJ, z));
  elif op(z, 0) = hold(_union) then
    _union(map(op(z), z->DOM_INTERVAL::besselJ(v, z)));
  else // v and z are simple intervals
    // TODO: branch here, asymptotics etc.
    DOM_INTERVAL::besselJ_series1(v, z);
  end_if;
end_proc:
