// 

// The absolute value, the center, and the width of an interval

// DOM_INTERVAL::abs is now a kernel function, since it is needed
// inside the kernel anyway.

DOM_INTERVAL::center := proc(iv)
local a, re, im;
begin
  a := hull(iv);
  re := Re(a);
  im := Im(a);
  subs((op(re,1) + op(re,2))/2, RD_NAN=0.0)
  + I*subs((op(im,1) + op(im,2))/2, RD_NAN=0.0);
end_proc:

// the semidiagonal of the enclosing hull
DOM_INTERVAL::width := proc(iv)
local a, re, im;
begin
  a := hull(iv);
  re := Re(a);
  im := Im(a);
  re := rdplus(op(re,2), -op(re,1), 1);
  im := rdplus(op(im,2), -op(im,1), 1);
  sqrt(rdplus(rdmult(re, re, 1), rdmult(im, im, 1), 1));
end_proc:

DOM_INTERVAL::width({}) := -infinity:

DOM_INTERVAL::dirac := proc(a, n=0)
begin
 if 0 in a then
   if iszero(n) then hull(0,RD_INF) else hull(RD_NINF, RD_INF) end_if;
 else 0 end_if;
end_proc:

DOM_INTERVAL::sign := proc(iv)
local result;
begin
 // TODO: Ensure iv is a DOM_INTERVAL
 if iv = {} then return(iv); end_if;
 if iszero(Im(iv)) then
    result := {};
    if op(iv, 1) < 0 then
       result := result union -1...-1;
    end_if;
    if op(iv, 1) <= 0 and 0 <= op(iv, 2) then
       result := result union 0...0;
    end_if;
    if 0 < op(iv, 2) then
       result := result union 1...1;
    end_if;
 else
    result := DOM_INTERVAL::exp(I*DOM_INTERVAL::arg(iv));
 end_if;
 result;
end_proc:
         
