// 

// hyperbolic trigonometric functions on DOM_INTERVALs.

DOM_INTERVAL::cosh := proc(a)
 local absa, l, r;
begin
 if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
 end_if;
 if op(a,0)=hold(_union) then
     _union(map(op(a), DOM_INTERVAL::cosh));
 elif op(a,0)=FAIL then // complex interval
   if 0 in Im(a) then
     // bugfix: cosh(-1...1) in cosh(-1...1+I)
     hull((DOM_INTERVAL::exp(a)+DOM_INTERVAL::exp(-a))/2,
	  DOM_INTERVAL::cosh(Re(a)));
   else
     (DOM_INTERVAL::exp(a)+DOM_INTERVAL::exp(-a))/2;
   end_if;
 else // real interval
     absa := DOM_INTERVAL::abs(a);
     l := DOM_INTERVAL::exp(hull(op(absa, 1)));
     r := DOM_INTERVAL::exp(hull(op(absa, 2)));
     (hull(l + _invert(l), r + _invert(r))/2)
        intersect hull(1, RD_INF);
 end_if;
end_proc:

DOM_INTERVAL::sinh :=
proc(a)
  local rea, ima;
begin
 if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
 end_if;
 if op(a,0)=hold(_union) then
   _union(map(op(a), DOM_INTERVAL::sinh));
 elif op(a,0) = FAIL then // complex interval
   ima := Im(a);
   rea := Re(a);
   DOM_INTERVAL::cos(ima)*DOM_INTERVAL::sinh_internal(rea)
   + I*DOM_INTERVAL::sin_internal(ima)*DOM_INTERVAL::cosh(rea);
 else
   DOM_INTERVAL::sinh_internal(a);
 end_if
end_proc:

DOM_INTERVAL::tanh := 
proc(a)
begin
 if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
 end_if;
 1 - 2/(DOM_INTERVAL::exp(2*a)+1);
end_proc:

DOM_INTERVAL::coth :=
proc(a)
begin
 if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
 end_if;
 1 + 2/(DOM_INTERVAL::exp(2*a)-1);
end_proc:

DOM_INTERVAL::arccosh := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
 if op(x,0) = hold(_union) then
     _union(map(op(x), DOM_INTERVAL::arccosh));
 else
     DOM_INTERVAL::ln(x+sqrt(x^2-1));
 end_if;
end_proc:

DOM_INTERVAL::arcsinh := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
 if op(x,0) = hold(_union) then
     _union(map(op(x), DOM_INTERVAL::arcsinh));
 elif op(x,0)=FAIL then
//   -I*DOM_INTERVAL::arcsin(I*z);
   DOM_INTERVAL::ln(sqrt(1+x^2)+x);
 else
   if x>=0 then
    DOM_INTERVAL::ln(sqrt(1+x^2)+x) intersect 0...RD_INF;
   elif x <= 0 then
    _negate(DOM_INTERVAL::ln(sqrt(1+x^2)-x)) intersect RD_NINF...0;
   else
    DOM_INTERVAL::arcsinh(x intersect RD_NINF...0)
    union
    DOM_INTERVAL::arcsinh(x intersect 0...RD_INF);
   end_if;
 end_if;
end_proc:

DOM_INTERVAL::arctanh := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
// DOM_INTERVAL::ln(-1-2/(x-1))/2;
 (DOM_INTERVAL::ln(x+1) - DOM_INTERVAL::ln(1-x))/2;
end_proc:

// This is needed in order not to get a singularity error
DOM_INTERVAL::arccsch := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
 DOM_INTERVAL::arcsinh(1/x);
end_proc:

// This is needed in order not to get a singularity error
DOM_INTERVAL::arcsech := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
 DOM_INTERVAL::arccosh(1/x);
end_proc:

DOM_INTERVAL::arccoth := proc(x)
begin
 if x::dom <> DOM_INTERVAL then
     if x = {} then return(x); end_if;
     return(FAIL);
 end_if;
 DOM_INTERVAL::arctanh(1/x);
end_proc:
