// 

// pivoting strategies applied up-front

// pivot trying to achieve diagonal dominance
interval::_pivot_maxdiag :=
proc(A, b)
  local i, j, jmax, n;
begin
  A := matrix(A);
  b := matrix(b);
  n := min(op(/*sparse*/matrix::matdim(A)));
  for i from 1 to n do
    jmax := i;
    for j from i+1 to n do
      if rhs(hull(max(abs(A[j,i])))) > rhs(hull(max(abs(A[jmax,i])))) then jmax := j; end_if;
    end_for;
    if jmax <> i then
      A := matrix::swapRow(A, i, jmax);
      b := matrix::swapRow(b, i, jmax);
    end_if;
  end_for;
  [A, b];
end_proc:
