// Bound on polynomial solutions of the Risch DE -- base case

// given a, b, c in k[t], with k=const(k), a<>0, return n in Z_
// such that degree(q) <= n for any solution q in k[t] of 
// a*diff(q,t)+b*q=c.

// Follows Bronstein, Symbolic Integration I, p. 199

intlib::algebraic::rde::boundDegreeBase :=
proc(a, b, c)
  local da, db, dc, m, n;
begin
  da := degree(a);
  db := degree(b);
  dc := degree(c);
  n := max(0, dc-max(db, da-1));
  if db=da-1 then // possible cancellation
    m := -lcoeff(b)/lcoeff(a);
    if testtype(m, Type::Integer) then
      n := max(0, m, dc-db);
    end_if;
  end_if;
  return(n);
end:
