// Bound on polynomial solutions of the Risch DE -- hyperexponential case

// given a, b, c in k[t], with t hyperexponential over k, a<>0, return n in Z_
// such that degree(q) <= n for any solution q in k[t] of 
// a*d(q)+b*q=c.

// Follows Bronstein, Symbolic Integration I, p. 200

intlib::algebraic::rde::boundDegreeExp :=
proc(a, b, c, ts, diffs, algs)
  local da, db, dc, m, m2, n, alpha, z;
begin
  assert(not has(normal(diffs[-1]/ts[-1]), ts[-1]));
  da := degree(a);
  db := degree(b);
  dc := degree(c);
  n := max(0, dc-max(db, da));
  if da=db then // possible cancellation
    alpha := intlib::algebraic::normal(-lcoeff(b)/lcoeff(a), [ts[-2]]);
    [m2, m, z] := intlib::algebraic::rde::parametricLogarithmicDerivative
      (alpha[1], alpha[2], ts, diffs, algs);
    if m2=1 then
      n := max(n,m);
    end_if;
  end_if;
  return(n);
end:
