// Diven a derivation on k[t] and a,b,c in k[t]
// with d(t) in k and a <> 0,
// return n in Z such that degree(q) <= n for any
// solution q in k[t] of a*d(q)+b*q=c.

// Follows Bronstein, Symbolic Integration I, p. 198

intlib::algebraic::rde::boundDegreePrim :=
proc(a, b, c, ts, diffs, algs)
  local da, db, dc, n, alpha, z, m, m1, d, w;
begin
  d := intlib::algebraic::diff(ts, diffs, algs);
  da := degree(a);
  db := degree(b);
  dc := degree(c);
  if db > da then
    n := max(0, dc - db)
  else
    n := max(0, dc - da + 1)
  end_if;
  assert(nops(ts)>1); // should go to boundDegreeBase otherwise
  if db = da-1 then // cancellation?
    alpha := -lcoeff(b)/lcoeff(a);
    [m1, m, z] := intlib::algebraic::rde::parametricDerivative
      (alpha[1], alpha[2], ts, diffs, algs);
    if m1=1 and testtype(m, DOM_INT) then
      n := max(n, m);
    end_if;
  elif db = da then // cancellation?
    alpha := intlib::algebraic::normal(-lcoeff(b)/lcoeff(a), [ts[-2]]);
    z := intlib::algebraic::logarithmicDerivative(alpha[1], alpha[2], ts[1..-2], diffs[1..-2], algs[1..-2]);
    if z <> FAIL then
      alpha := intlib::algebraic::normal(-lcoeff(multcoeffs(a,d(z))
        +multcoeffs(b,z))/(z*lcoeff(a)), [ts[-2]]);
      [m1, m, w] := intlib::algebraic::rde::parametricDerivative
        (alpha[1], alpha[2], ts, diffs, algs);
      if m1=1 and testtype(m, DOM_INT) then
        n := max(n, m);
      end_if;
    end_if;
  end_if;
  n;
end:
