// Generate linear constraints on the constraints

// Given a derivation d on k(t), a, b in k[t] and
// g1, g2, ..., gm in k(t), return q1, ..., qm in k(t)
// and a matrix M (as a hash) with entries in k
// such that for any solution c1, ..., cm in Const(k) 
// and p in k[t] of a*d(p) + b*p = c1*g1+...+cm*gm, 
// (c1,...,cm) is a solution of M*x=0, and p and the ci 
// satisfy a*d(p)+b*p=c1*q1+...+cm*qm.

// Follows Bronstein, Symbolic Integration I, p. 223.

intlib::algebraic::rde::linearConstraints :=
proc(a, b, ts, diffs, algs, g)
  local i, j, d, q, r, N, M, A;
begin
  d := lcm(op(map(g, op, 2))); // lcm of the denominators
  q := map(g, gi -> [divide(gi[1]*divide(d, gi[2], Quo /* Exact */), d)]);
  r := map(q, op, 2);
  q := map(q, op, 1);
  N := max(0, op(map(r, degree)));
  M := [[coeff(j, i) $ j in r] $ i=0..N];
  M := select(M, m -> {op(m)} <> {0});
  A := table(0);
  A["m"] := nops(g);
  A["rows"] := nops(M);
  A["cols"] := nops(r);
  for i from 1 to nops(M) do
    for j from 1 to nops(r) do
      A[i, j] := M[i][j];
    end_for;
  end_for;
  return([q, A]);
end:
